<?php
/**
 * The template for displaying single room review.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/single-room/review.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.6
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

$rating   = intval( get_comment_meta( $comment->comment_ID, 'rating', true ) );
$settings = WPHB_Settings::instance();
?>
<li itemprop="review" itemscope itemtype="http://schema.org/Review" <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
  <div id="comment-<?php comment_ID(); ?>" class="comment__wrap comment_container">
    <div class="comment__avatar">
      <?php echo get_avatar( $comment, apply_filters( 'hb_review_gravatar_size', '49' ), '' ); ?>
    </div>
    <div class="comment__header">
      <?php if ( $comment->comment_approved == '0' ) : ?>
        <p class="meta"><em><?php esc_html__( 'Your comment is awaiting approval', 'luxe' ); ?></em></p>
      <?php else: ?>
        <div class="comment__author"><?php comment_author(); ?></div>
      <?php endif; ?>
      <time class="comment__date" datetime="<?php echo get_comment_date( 'c' ); ?>"><?php echo get_comment_date( hb_date_format() ); ?></time>

      <?php if ( $rating && $settings->get( 'enable_review_rating' ) ) : ?>
        <div itemprop="reviewRating" itemscope itemtype="http://schema.org/Rating" class="star-rating" title="<?php echo sprintf( __( 'Rated %d out of 5', 'luxe' ), $rating ) ?>">
          <span style="width:<?php echo ( $rating / 5 ) * 100; ?>%"></span>
        </div>
      <?php endif; ?>

    </div>
    <div class="comment__text"><?php comment_text(); ?></div>
  </div>
</li>