<?php
/**
 * The template for displaying single room gallery.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/single-room/gallery.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.6
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

global $hb_room;
$galeries            = $hb_room->get_galleries( false );
$hotel_gallery_on_ff = luxe_get_opt('single-room-gallery');

if(is_array($galeries) && !empty($galeries) && $hotel_gallery_on_ff):
?>

<div class="block block--image-gallery">
  <h2 class="block__title"><?php echo luxe_translate('gallery-elegence', 'Gallery of Elegance'); ?></h2>
  <div class="block__content">
    <div class="image-gallery">
      <div class="image-gallery__main">
        <?php 
          foreach ( $galeries as $key => $gallery ): 
            $image_url = luxe_get_image_src($gallery['id'], 'luxe-large');
        ?>
            <div class="image-gallery__item"><img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($gallery['alt']); ?>"></div>
        <?php endforeach; ?>
      </div>
      <ul class="image-gallery__thumbs">
        <?php foreach ( $galeries as $key => $gallery ): $thumb_url = luxe_get_image_src($gallery['id'], 'luxe-thumb'); ?>
            <li class="image-gallery__thumb"><button class="image-gallery__button"><img src="<?php echo esc_url($thumb_url); ?>" alt="<?php echo esc_attr($gallery['alt']); ?>"></button></li>
        <?php endforeach; ?>
      </ul>
    </div>
  </div>
</div>
<?php endif; ?>
