<?php
/**
 * The template for displaying search room results.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/search/results.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.6
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();
do_action( 'hb_before_search_result' );
?>
<?php
global $hb_search_rooms;
?>

<div id="hotel-booking-results" class="bookings">
  <?php if ( $results && !empty( $hb_search_rooms['data'] ) ): ?>
    <?php hb_get_template( 'search/list.php', array( 'results' => $hb_search_rooms['data'], 'atts' => $atts ) ); ?>
        <nav class="blog-nav">
      <?php
      echo paginate_links( apply_filters( 'hb_pagination_args', array(
        'base'      => add_query_arg( 'hb_page', '%#%' ),
        'format'    => '',
        'prev_text' => esc_html__( 'Previous', 'luxe' ),
        'next_text' => esc_html__( 'Next', 'luxe' ),
        'total'     => $hb_search_rooms['max_num_pages'],
        'current'   => $hb_search_rooms['page'],
        'type'      => 'plain',
        'end_size'  => 3,
        'mid_size'  => 3
      ) ) );
      ?>
        </nav>
  <?php else: ?>
    <div class="hb-no__result">
      <h4 class="title"><i class="fa fa-info-circle"></i><?php echo esc_html__( 'No results for this search', 'luxe' ); ?></h4>
    </div>
  <?php endif; ?>
</div>
