<?php
/**
 * The template for displaying search room item loop.
 *
 * This template can be overridden by copying it to yourtheme/wp-hotel-booking/search/loop.php.
 *
 * @author  ThimPress, leehld
 * @package WP-Hotel-Booking/Templates
 * @version 1.6
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();
global $hb_settings;
$gallery                   = $room->gallery;
$featured                  = $gallery ? array_shift( $gallery ) : false; 
$search_result_capacity    = luxe_get_opt('search-result-capacity');
$search_result_children    = luxe_get_opt('search-result-children');
$search_result_animities   = luxe_get_opt('search-result-animities');
$search_result_description = luxe_get_opt('search-result-desc');
$single_purchase           = get_option( 'tp_hotel_booking_single_purchase' );
$room_description          = $room->addition_information;

?>

<div class="hb-rooms clearfix">
  <form name="hb-search-results" class="hb-search-room-results">
    <?php do_action( 'hotel_booking_loop_before_item', $room->post->ID ); ?>
    <div class="booking">
      <?php if ( $featured ): ?>
        <div class="booking__col booking__col--img">
          <a class="hb-room-gallery" data-lightbox="hb-room-gallery[<?php echo esc_attr( $room->post->ID ); ?>]" data-title="<?php echo esc_attr( $featured['alt'] ); ?>" href="<?php echo esc_attr( $featured['src'] ); ?>"><?php $room->getImage('catalog'); ?></a>
        </div>
      <?php endif; ?>

      <div class="booking__col booking__col--main">
        <h3 class="booking__title">
          <a href="<?php echo get_the_permalink( $room->ID ) ?>">
            <?php echo esc_html( $room->name ); ?>
          </a>
        </h3>
        <ul class="booking-meta">
          <?php if($search_result_capacity): ?>
            <li class="booking-meta__item"><i class="fa fa-th-large"></i> <?php echo esc_html( $room->capacity ); ?> <?php echo luxe_translate('capacity', 'Capacity'); ?></li>
          <?php endif; ?>
          <?php if($search_result_children): ?>
            <li class="booking-meta__item"><i class="fa fa-user-o"></i> <?php echo esc_html( $room->max_child ); ?> <?php echo luxe_translate('children', 'Children'); ?></li>
          <?php endif; ?>
          <?php if ( ! $single_purchase ): ?>
          <li class="hb_search_quantity">
            <label><?php echo luxe_translate('quantity', 'Quantity'); ?></label>
            <div>
              <?php
                hb_dropdown_numbers(
                array(
                  'name'             => 'hb-num-of-rooms',
                  'min'              => 1,
                  'show_option_none' => luxe_translate('select', 'Select'),
                  'max'              => $room->post->available_rooms,
                  'class'            => 'number_room_select'
                )
              );
              ?>
            </div>
          </li>
        <?php else: ?>
          <select name="hb-num-of-rooms" class="number_room_select" style="display: none;">
              <option value="1">1</option>
          </select>
          <?php endif; ?>
        </ul>
        <?php if(!empty($room_description) && $search_result_description): ?>
          <div class="booking-desc"><?php echo luxe_post_excerpt(15, $room_description); ?></div>
        <?php endif; ?>
        <?php $animities = luxe_search_animities($room->post->post_content);  ?>
        <?php if(is_array($animities) && !empty($animities)): ?>
          <ul class="amenities-sm">
            <?php foreach($animities as $animity): ?>
              <li class="amenity-sm">
                <i class="<?php echo esc_attr($animity['icon']); ?>"></i>
                <span class="amenity-sm__tooltip"><?php echo esc_html($animity['label']); ?></span>
              </li>
            <?php endforeach; ?>
          </ul>
        <?php endif; ?>
      </div>

      <div class="booking__col booking__col--action">
        <div class="booking__action-col">
          <div class="booking__price-label"><?php echo luxe_translate('price', 'Price'); ?></div>
          <div class="booking__price"><?php echo hb_format_price( $room->amount_singular ); ?></div>
        </div>
        <div class="booking__action-col hb_search_add_to_cart">
          <button class="btn btn--booking"><?php echo luxe_translate('select-room', 'Select Room'); ?></button>
        </div>
      </div>


    </div>

    <?php wp_nonce_field( 'hb_booking_nonce_action', 'nonce' ); ?>
    <input type="hidden" name="check_in_date" value="<?php echo date( 'm/d/Y', hb_get_request( 'hb_check_in_date' ) ); ?>" />
    <input type="hidden" name="check_out_date" value="<?php echo date( 'm/d/Y', hb_get_request( 'hb_check_out_date' ) ); ?>">
    <input type="hidden" name="room-id" value="<?php echo esc_attr( $room->post->ID ); ?>">
    <input type="hidden" name="hotel-booking" value="cart">
    <input type="hidden" name="action" value="hotel_booking_ajax_add_to_cart" />
    <?php do_action( 'hotel_booking_loop_after_item', $room->post->ID ); ?>
  </form>
  <?php if ( ( isset( $atts['gallery'] ) && $atts['gallery'] === 'true' ) || $hb_settings->get( 'enable_gallery_lightbox' ) ): ?>
    <?php hb_get_template( 'loop/gallery-lightbox.php', array( 'room' => $room ) ) ?>
  <?php endif; ?>

</div>