<?php
/**
 * Loop Price
 *
 * @author        ThimPress
 * @package       wp-hotel-booking/templates
 * @version       1.6
 */

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $hb_settings;
$price_display = apply_filters( 'hotel_booking_loop_room_price_display_style', $hb_settings->get( 'price_display' ) );

$prices = hb_room_get_selected_plan( get_the_ID() );
$prices = isset( $prices->prices ) ? $prices->prices : array();

?>
<?php if ( $prices ): ?>
	<?php
	$min = min( $prices ) + ( hb_price_including_tax() ? ( min( $prices ) * hb_get_tax_settings() ) : 0 );
	?>
  <div class="rooms-slider__price"><?php echo luxe_translate('starting-from', 'Starting from'); ?> <?php echo hb_format_price( $min ); ?>/<?php echo luxe_translate('night', 'night'); ?></div>
<?php endif; ?>
