<?php

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly
}

if(!function_exists('hotel_booking_single_page_header')) {
  /**
  * @return null
  * @param none
  * hotel_single_page_header
  **/
  function hotel_booking_single_page_header() { 
    $prices         = hb_room_get_selected_plan( get_the_ID() );
    $subtitle       = get_post_meta(get_the_ID(), '_hb_subtitle', true);
    $prices         = isset( $prices->prices ) ? $prices->prices : array();
    $max            = max( $prices ) + ( hb_price_including_tax() ? ( max( $prices ) * hb_get_tax_settings() ) : 0 );
    $featured_image = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID()), 'full');
    $data_image     = (is_array($featured_image) && !empty($featured_image)) ? ' data-image-src='.esc_url($featured_image[0]):''; ?>
    <div class="page-header" data-parallax="scroll"<?php echo esc_attr($data_image); ?>>
      <div class="container">
        <div class="page-header__wrap">
          <div class="page-header__col page-header__col--title">
            <h1 class="page-title"><?php the_title(); ?></h1>
            <?php if(!empty($subtitle)): ?>
              <div class="page-description"><?php echo esc_html($subtitle); ?></div>
            <?php endif; ?>
          </div>
          <div class="page-header__col">
            <div class="page-price">
              <div class="page-price__label"><?php echo luxe_translate('price-per-night', 'Price per night'); ?></div>
              <?php if(!empty($max)): ?>
                <div class="page-price__val"><?php echo hb_format_price($max); ?></div>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </div>
    </div>
    <?php
  }
  add_action('hotel_booking_single_page_header', 'hotel_booking_single_page_header');
}

if(!function_exists('hotel_booking_single_description')) {
  /**
  * @return null
  * @param none
  * hotel_booking_single_description
  **/
  function hotel_booking_single_description() { 
    $room                     = WPHB_Room::instance( get_the_ID() );
    $hotel_description_on_off = luxe_get_opt('single-room-desc');
    $addition_information = $room->addition_information;
    if(!empty($addition_information) && $hotel_description_on_off):
  ?>
    <div class="block">
      <h2 class="block__title"><?php echo luxe_translate('little-description', 'Little description'); ?></h2>
      <div class="block__content">
        <?php echo wp_kses_post($addition_information); ?>
      </div>
    </div>
  <?php endif;

  }
  add_action('hotel_booking_single_description', 'hotel_booking_single_description');
}

if(!function_exists('append_subtitle_field') && class_exists('WP_Hotel_Booking')) {
  /**
  * @return null
  * @param none
  * append_subtitle_field
  **/
  function append_subtitle_field() {
    WPHB_Meta_Box::instance(
        'room_settings',
        array(
          'title'           => esc_html__( 'Room Settings', 'luxe' ),
          'post_type'       => 'hb_room',
          'meta_key_prefix' => '_hb_', // meta key prefix,
          'priority'        => 'high'
        ),
        array()
      )->add_field(
        array(
        'name'  => 'subtitle',
        'label' => __( 'Subtitle', 'luxe' ),
        'type'  => 'text',
        'desc'  => esc_html__( 'Enter subtitle below heading', 'luxe' ),
        )
      );
  }
  add_action('admin_init', 'append_subtitle_field');
}


if(!function_exists('hotel_booking_single_room_review') && class_exists('WP_Hotel_Booking')) {
  function hotel_booking_single_room_review() {
    if ( comments_open() ) {
      comments_template();
    }
  }
  add_action('hotel_booking_single_room_review', 'hotel_booking_single_room_review');
}



if(!function_exists('luxe_is_room')) {
  /**
  * @return true/false
  * @param none
  * luxe_is_room
  **/
  function luxe_is_room() {
    $is_hotel_room = (class_exists('WP_Hotel_Booking')) ? is_room():false;
    return $is_hotel_room;
  }
}

if(!function_exists('luxe_is_search_result')) {
  /**
  * @return true/false
  * @param none
  * luxe_is_search_result
  **/
  function luxe_is_search_result() {
    $is_search_empty = (class_exists('WP_Hotel_Booking')) ? $_REQUEST:'';
    return is_array($is_search_empty) && (array_key_exists('hotel-booking', $is_search_empty) && $is_search_empty['hotel-booking'] == 'results') ? true:false;
  }
}

if(!function_exists('luxe_search_animities')) {
  /**
  * @return true/false
  * @param none
  * luxe_is_search_result
  **/
  function luxe_search_animities($post_content) {
    if(!class_exists('Vc_Manager') || empty($post_content) || !has_shortcode($post_content, 'rs_animities')) { return; }
    preg_match_all('/animity="([^"]+)"/', $post_content, $matches);
    $animity = str_replace('animity="', '', $matches[0][0]);
    $animity = str_replace('"', '', $animity);

    $animity_data = array();
    $animities    = (array) vc_param_group_parse_atts( $animity );
    foreach ($animities as $key => $value) {
      $new_data = $value;
      $new_data['icon'] = isset( $value['icon'] ) ? $value['icon'] : '';
      $new_data['label'] = isset( $value['label'] ) ? $value['label'] : '';
      $animity_data[] = $new_data;
    }
    return (array) $animity_data;
  }
}
