<?php
/**
 * Template Name: Blog List
 *
 * @package luxe
*/
get_header();

if (get_query_var('paged')) {
  $paged = get_query_var('paged');
} elseif (get_query_var('page')) {
  $paged = get_query_var('page');
} else {
  $paged = 1;
}
$post_per_page = luxe_get_post_opt('blog-posts-per-page');
if (!$post_per_page) {
  $post_per_page = get_option('posts_per_page');
}

$post_args = array(
  'posts_per_page' => $post_per_page,
  'orderby'        => 'date',
  'paged'          => $paged,
  'order'          => 'DESC',
  'post_type'      => 'post',
  'post_status'    => 'publish'
);

$post_blog_column = luxe_blog_post_column();
$categories = luxe_get_post_opt('blog-category');
if (is_array($categories)) {
  $post_args['category__in'] =  $categories;
}

$query = new WP_Query( $post_args );
if(is_page()) {
  $max_num_pages = $query->max_num_pages;
} else {
  global $wp_query;
  $query = $wp_query;
  $max_num_pages = false;
}

?>

<div class="content">
  <div class="marg-lg-b100 marg-md-b50 marg-xs-b50"></div>
  <div class="container">
    <?php get_template_part('theme/inc/global/page-before-content'); ?>
      <div class="row blog-roll__post">
        <div class="isotope isotope-content">
          <?php echo luxe_blog_post_grid_sizer(); ?>
          <?php if($query -> have_posts()): while ($query -> have_posts()) : $query -> the_post(); ?>
            <div <?php post_class($post_blog_column); ?>>
              <div class="recent-post">
                <?php luxe_blog_post_format(); ?>
                <div class="recent-post__wrap">
                  <a href="<?php echo esc_url(get_the_permalink()); ?>" class="recent-post__title"><?php the_title(); ?></a>
                  <div class="recent-post__meta">
                   <span class="author-name"><?php echo get_the_author(); ?></span>
                  <?php echo esc_html__('on', 'luxe'); ?> <?php echo get_the_category_list( esc_html__( ', ', 'luxe' ) );?>
                  </div>
                  <div class="recent-post__excerpt"><?php echo luxe_auto_post_excerpt(); ?></div>
                  <a class="recent-post__link" href="<?php echo esc_url(get_the_permalink()); ?>"><?php echo esc_html__('Read more', 'luxe'); ?></a>
                </div>
              </div>
            </div>
          <?php endwhile; wp_reset_postdata(); else: 
            get_template_part('theme/inc/content/content', 'none');
          endif; ?>
        </div>
        <?php luxe_paging_nav($max_num_pages, 'default'); ?>
      </div>
      <?php get_template_part('theme/inc/global/page-after-content'); ?>
    </div>
  <div class="marg-lg-b100 marg-md-b50 marg-xs-b50"></div>
</div>

<?php
get_footer();
