<?php
/**
 * Header Template file
 *
 * @package luxe
 * @since 1.0
 */
?>
<?php
  $header_phone    = luxe_get_opt('header-phone-number');
  $header_location = luxe_get_opt('header-location');
?>
<header class="site-header hb-header__style3">
  <?php luxe_top_header(); ?>
  <div class="above-menu">
    <div class="container">
      <div class="above-menu__item">
        <?php luxe_logo('logo', 'hb-logo__logo__1x', get_theme_file_uri('assets/images/logo.png')); ?>
        <?php luxe_logo('logo-2x', 'hb-logo__logo__2x', get_theme_file_uri('assets/images/logo@2x.png', true)); ?>
      </div>
      
      <div class="above-menu__item above-menu__item--widgets">
        <div class="widget widget_contactinfo">
          <ul class="contact-info">
            <?php if(!empty($header_phone)): ?>
              <li class="contact-info-item">
                <a href="#">
                  <i class="fa fa-phone"></i>
                  <?php echo esc_html($header_phone); ?>
                </a>
              </li>
            <?php endif; ?>
            <?php if(!empty($header_location)): ?>
              <li class="contact-info-item">
                <i class="fa fa-map-marker"></i> <?php echo esc_html($header_location); ?>
              </li>
            <?php endif; ?>
          </ul>
        </div>

        <div class="widget widget_social">
          <?php luxe_social_links('%s', luxe_get_opt('header-social-icons-category')); ?>
        </div>
      </div>
    </div>
  </div>
  <div class="nav-bar nav-bar--center nav-bar--sticky">
    <div class="container">
      <div class="nav-bar__item nav-bar__item--menu">
        <?php luxe_main_menu('site-menu'); ?>
      </div>

      <div class="nav-bar__item nav-bar__item--mobile">
        <button class="btn btn--mobile-toggle"><i class="fa fa-bars"></i></button>
      </div>
    </div>
  </div>
</header>