<?php
/**
 * The template for displaying comments.
 *
 * The area of the page that contains both current comments
 * and the comment form.
 *
 * @package luxe
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
  if ( post_password_required() ) {
    return;
  }
?>

<!-- Comments -->
<?php echo (is_page()) ? '<div class="marg-lg-b20"></div>':''; ?>
<section class="comment-item">
  <?php if(have_comments()): ?>
  <section class="post-comment block" id="comments">
    <h2 class="block__title"><?php echo get_comments_number(); ?> <?php esc_html_e('Comments', 'luxe'); ?></h2>
      <div class="block__content">
        <ol class="comments commentlist">
          <?php
            wp_list_comments( array(
              'callback'     => 'luxe_comment',
              'end-callback' => 'luxe_close_comment',
              'style'        => 'ol',
              'short_ping'   => true,
            ) );
          ?>
        </ol>
      </div>
      

    <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
      <nav id="comment-nav-above" class="navigation comment-navigation" role="navigation">
        <h2 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'luxe' ); ?></h2>
        <div class="nav-links">

          <div class="nav-previous"><?php previous_comments_link( esc_html__( 'Older Comments', 'luxe' ) ); ?></div>
          <div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments', 'luxe' ) ); ?></div>

        </div><!-- .nav-links -->
      </nav><!-- #comment-nav-above -->
    <?php endif; // check for comment navigation ?>

  </section>
  <?php endif; ?>

  <!-- Add Comment -->
  <?php if(comments_open()): ?>
    <div class="block hb-comment__form clearfix">

      <?php
        $commenter = wp_get_current_commenter();
        $req       = get_option( 'require_name_email' );
        $aria_req  = ( $req ? " aria-required='true'" : '' );

        $args = array(
          'id_form'           => 'commentform',
          'class_form'        => 'block__content',
          'id_submit'         => 'comment_submit',
          'title_reply'       => esc_html__( 'Leave a Comment' ,'luxe'),
          'title_reply_to'    => esc_html__( 'Leave a Comment to %s'  ,'luxe'),
          'cancel_reply_link' => esc_html__( 'Cancel Comment'  ,'luxe'),
          'label_submit'      => esc_html__( 'Post Comment'  ,'luxe'),
          'comment_field'     => '
            <div class="input--textarea"><textarea name="comment" id="text" ' . $aria_req . ' class="input__field placeholder" rows="1" placeholder="'.esc_attr__('Your Comment', 'luxe').'"  maxlength="400"></textarea></div>
            ',
          'must_log_in'          => '<p class="must-log-in">' .  wp_kses_post(sprintf( __( 'You must be <a href="%s">logged in</a> to post a comment.' ,'luxe' ), wp_login_url( apply_filters( 'the_permalink', get_permalink( ) ) ) )) . '</p>',
          'logged_in_as'         => '<p class="logged-in-as">' . wp_kses_post(sprintf( __( 'Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s" title="'.esc_attr__('Log out of this account', 'luxe').'">Log out?</a>'  ,'luxe'), admin_url( 'profile.php' ), $user_identity, wp_logout_url( apply_filters( 'the_permalink', get_permalink( ) ) ) ) ). '</p>',
          'comment_notes_before' => '',
          'comment_notes_after'  => '',
          'class_submit'         => 'btn',
          'fields' => apply_filters( 'comment_form_default_fields',
            array(
              'author' => '
                  <div class="row"><div class="marg-lg-b10"></div><div class="col-sm-4">
                    <!-- Name -->
                    <div class="input--user"><input type="text" name="author" id="name" ' . $aria_req . ' class="input__field placeholder" placeholder="'.esc_attr__('Name', 'luxe').'" maxlength="100"></div></div>',

              'email' => '
                  <div class="col-sm-4"><div class="input--email"><input type="email" name="email" id="email" placeholder="'.esc_attr__('Email', 'luxe').'" class="input__field placeholder" maxlength="100"></div></div>',

              'url' => '
                <div class="col-sm-4"><div class="input--website"><input type="text" name="url" id="website" placeholder="'.esc_attr__('Website', 'luxe').'" class="input__field placeholder" maxlength="100"></div></div></div>',
            )
          )
        );
        comment_form($args);
      ?>
    
    </div>
    <!-- End Add Comment -->
  <?php endif; ?>
</section>
<!--end of comments-->
