<?php
/**
 * Archive Page
 *
 * @package luxe
 * @since 1.0
 */
get_header(); 

  $archive_read_more_on_off = luxe_get_opt('archive-page-read-more');
  $archive_category_on_off  = luxe_get_opt('archive-page-category');
  $archive_author_on_off    = luxe_get_opt('archive-page-author');
  $post_blog_column         = luxe_blog_post_column();
?>

<div class="content">
  <div class="marg-lg-b50 marg-md-b50 marg-xs-b50"></div>
  <div class="container">
    <?php get_template_part('theme/inc/global/page-before-content'); ?>
      <div class="row blog-roll__post">
        <div class="isotope isotope-content">
          <?php echo luxe_blog_post_grid_sizer(); ?>
          <?php if(have_posts()): while (have_posts()) : the_post(); ?>
            <div <?php post_class($post_blog_column); ?>>
              <div class="recent-post">
                <?php luxe_blog_post_format(); ?>
                <div class="recent-post__wrap">
                  <a href="<?php echo esc_url(get_the_permalink()); ?>" class="recent-post__title"><?php the_title(); ?></a>
                  <div class="recent-post__meta">
                  <?php if($archive_author_on_off): ?>
                      <?php echo get_the_author(); ?>
                    <?php endif; ?>
                    <?php if($archive_category_on_off): ?>
                      <?php echo esc_html__('on', 'luxe'); ?> <?php echo get_the_category_list( esc_html__( ', ', 'luxe' ) );?>
                    <?php endif; ?>
                  </div>
                  <div class="recent-post__excerpt"><?php echo luxe_auto_post_excerpt(); ?></div>
                  <?php if($archive_read_more_on_off): ?>
                    <a class="recent-post__link" href="<?php echo esc_url(get_the_permalink()); ?>"><?php echo esc_html__('Read more', 'luxe'); ?></a>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          <?php endwhile; else: 
            get_template_part('templates/content', 'none');
          endif; ?>
        </div>
        <?php luxe_paging_nav(false, 'default'); ?>
      </div>
      <?php get_template_part('theme/inc/global/page-after-content'); ?>
    </div>
  <div class="marg-lg-b50 marg-md-b50 marg-xs-b50"></div>
</div>

<?php
get_footer();

