<?php
/**
 * Customizer Section
 */

$this->sections[] = array(
  'title' => esc_html__('Typography', 'luxe'),
  'desc' => esc_html__('Check child sections to style properly the correct area of the theme.', 'luxe'),
  'icon' => 'fa fa-text-width',
  'fields' => array(

  ), // #fields
);
$this->sections[] = array(
  'title' => esc_html__('Heading', 'luxe'),
  'desc' => esc_html__('Configure heading styles.', 'luxe'),
  'subsection' => true,
  'fields' => array(
    array(
      'id'             => 'font-heading-h1',
      'type'           => 'typography',
      'title'          => esc_html__('H1,H2,H3,H4,H5,H6', 'luxe'),
      'font-size'      => true,
      'font-style'     => true,
      'letter-spacing' => true,
      'text-transform' => true,
      'font-weight'    => true,
      'line-height'    => true,
      'text-align'     => false,
      // 'fonts'          => array('sdfsf'=>'sdfsfdf'),
      'color'          => true,
      'preview'        => array('always_display' => true),
      'output'         => array(
        '.featured-rooms-slider__title,
        .page-title,
        .page-price__val,
        .booking__title,
        .booking__price,
        .title,
        .featured-room__title,
        .icon--style-2 .icon__title,
        .testimonial__name,
        .rooms-slider__title,
        .hb-slider .hb-slider__text h2'
      ),
    ),
  ),
);

$this->sections[] = array(
  'title' => esc_html__('Body', 'luxe'),
  'desc' => esc_html__('Configure body styles.', 'luxe'),
  'subsection' => true,
  'fields' => array(
    array(
      'id'          => 'font-body-theme',
      'type'        => 'typography',
      'title'       => esc_html__('Body', 'luxe'),
      'font-size'   => true,
      'line-height' => true,
      'text-align'  => false,
      'color'       => true,
      'output'      => array('body,.icon--style-1 .icon__title,.icon--style-1 .icon__text,.icon--style-2 .icon__text'),
      'preview'     => array('always_display' => true),
    ),
  ),
);

