<?php
/*
 * Menu Section
*/
$this->sections[] = array(
  'title' => esc_html__('Menu', 'luxe'),
  'icon' => 'fa fa-bars',
  'desc' => esc_html__('Change the menu section configuration.', 'luxe'),
  'fields' => array(
    array(
      'id'=>'header-primary-menu',
      'type' => 'select',
      'title' => esc_html__('Primary Menu', 'luxe'),
      'subtitle' => esc_html__('Select a menu to overwrite the header menu location.', 'luxe'),
      'data' => 'menus',
      'default' => '',
    ),
    array(
      'id' => 'random-number',
      'type' => 'info',
      'desc' => '<h3 style="color:#0073aa;">'.esc_html__('Menu Color Settings', 'luxe').'</h3>'
    ),
    array(
      'id'      => 'customizer-header-menu-link-color',
      'type'    => 'color',
      'title'   => esc_html__('Menu Link Color', 'luxe'),
      'default' => '',
      'output'  => array('color' => '.site-menu a')
    ),
    array(
      'id'      => 'customizer-header-menu-link-hover-color',
      'type'    => 'color',
      'title'   => esc_html__('Menu Link Hover Color', 'luxe'),
      'default' => '',
      'output'  => array('color' => '.site-menu a:hover, .site-menu a:focus')
    ),    
    array(
      'id'       => 'customizer-header-menu-link-hover-bg-color',
      'type'     => 'color',
      'title'    => esc_html__('Menu Link Hover Background Color', 'luxe'),
      'default'  => '',
      'output'   => array('background' => '.site-menu a:hover'),
    ),
    array(
      'id'      => 'customizer-header-sub-menu-link-color',
      'type'    => 'color',
      'title'   => esc_html__('Sub Menu Link Color', 'luxe'),
      'default' => '',
      'output'  => array('color' => '.site-menu .sub-menu a')
    ),
    array(
      'id'      => 'customizer-header-sub-menu-link-hover-color',
      'type'    => 'color',
      'title'   => esc_html__('Sub Menu Link Hover Color', 'luxe'),
      'default' => '',
      'output'  => array('color' => '.site-menu .sub-menu a:hover')
    ),    
    array(
      'id'      => 'customizer-header-sub-menu-link-hover-bg-color',
      'type'    => 'color',
      'title'   => esc_html__('Sub Menu Hover Background Color', 'luxe'),
      'default' => '',
      'output'  => array('background' => '.site-menu .sub-menu a:hover, .site-menu .sub-menu a:focus')
    ),
    array(
      'id' => 'random-number',
      'type' => 'info',
      'desc' => '<h3 style="color:#0073aa;">'.esc_html__('Menu Typography Settings', 'luxe').'</h3>'
    ),
    array(
      'id'             => 'customizer-header-menu-link-typo',
      'type'           => 'typography',
      'title'          => esc_html__('Menu Link', 'luxe'),
      'font-size'      => true,
      'font-style'     => true,
      'letter-spacing' => true,
      'text-transform' => true,
      'line-height'    => true,
      'text-align'     => false,
      'color'          => false,
      'output'         => array('.site-menu a'),
    ),
    array(
      'id'             => 'customizer-header-sub-menu-link-typo',
      'type'           => 'typography',
      'title'          => esc_html__('Sub Menu Link', 'luxe'),
      'font-size'      => true,
      'font-style'     => true,
      'letter-spacing' => true,
      'text-transform' => true,
      'line-height'    => true,
      'text-align'     => false,
      'color'          => false,
      'output'         => array('.site-menu .sub-menu a'),
    ),
  ), // #fields
);
