<?php
/*
 * Header Section
*/
$this->sections[] = array(
  'title' => esc_html__('Header', 'luxe'),
  'desc' => esc_html__('Change the header section configuration.', 'luxe'),
  'icon' => 'fa fa-window-maximize',
  'fields' => array(
    array(
      'id' => 'header-enable-switch',
      'type' => 'switch',
      'title' => esc_html__('Enable Header', 'luxe'),
      'options' => array(
        '1' => 'On',
        '0' => 'Off',
      ),
      'default' => '1',
      'subtitle' => esc_html__('If on, this layout part will be displayed.', 'luxe'),
    ),
    array(
      'id'       => 'header-template',
      'type'     => 'image_select',
      'width'    => '180',
      'title'    => esc_html__('Template', 'luxe'),
      'subtitle' => esc_html__('Choose template for navigation header.', 'luxe'),
      'options'  => array(
        'header-style1'  => array(
          'alt' => 'Header Style 1',
          'img' => get_theme_file_uri('admin/assets/img/panel/1.png')
        ),
        'header-style2'  => array(
          'alt' => 'Header Style 2',
          'img' => get_theme_file_uri('admin/assets/img/panel/3.png')
        ),
        'header-style3'  => array(
          'alt' => 'Header Style 3',
          'img' => get_theme_file_uri('admin/assets/img/panel/2.png')
        ),
        'header-style4'  => array(
          'alt' => 'Header Style 4',
          'img' => get_theme_file_uri('admin/assets/img/panel/4.png')
        ),
      ),
      'default' => 'header-style1',
      'validate' => '',
    ),
    array(
      'id'   => 'random-number',
      'type' => 'info',
      'desc' => wp_kses_post('<h2 style="color:#0073aa;">Logo Module</h2>')
    ),
    array(
      'id'      => 'customizer-logo-container-bg',
      'type'    => 'color',
      'title'   => esc_html__('Logo Container Background Color', 'luxe'),
      'default' => '',
      'transparent' => false,
      'required' => array('header-template', 'equals', array('header-style4')),
    ),
    array(
      'id'      =>'logo-container-height',
      'type'    => 'text',
      'title'   => esc_html__('Container Height', 'luxe'),
      'default' => '',
      'desc'    => 'Enter height for logo container (optional)',
      'required' => array('header-template', 'equals', array('header-style2')),
    ),
    array(
      'id'=>'logo',
      'type' => 'media',
      'url' => true,
      'title' => esc_html__('Logo', 'luxe'),
      'subtitle' => esc_html__('Upload the logo that will be displayed in the header.', 'luxe'),
    ),
    array(
      'id'      =>'logo-width',
      'type'    => 'text',
      'title'   => esc_html__('Width', 'luxe'),
      'default' => '86',
      'desc'    => 'Enter logo width or type "auto" (optional)'
    ),
    array(
      'id'      =>'logo-height',
      'type'    => 'text',
      'title'   => esc_html__('Height', 'luxe'),
      'default' => '27',
      'desc'    => 'Enter logo height or type "auto" (optional)'
    ),
    array(
      'id'   => 'random-number',
      'type' => 'info',
      'desc' => wp_kses_post('<h2 style="color:#0073aa;">Logo Retina Module</h2>'),
    ),
    array(
      'id'=>'logo-2x',
      'type' => 'media',
      'url' => true,
      'title' => esc_html__('Logo Retina (@2x)', 'luxe'),
      'subtitle' => esc_html__('Upload the logo that will be displayed in the header.', 'luxe'),
    ),
    array(
      'id'       => 'random-number-contact',
      'type'     => 'info',
      'desc'     => wp_kses_post('<h2 style="color:#0073aa;">Contact Information</h2>'),
      'required' => array('header-template', 'equals', array('header-style3')),
    ),
    array(
      'id'       => 'header-phone-number',
      'type'     => 'text',
      'title'    => esc_html__('Phone Number', 'luxe'),
      'default'  => '1 877 834 3613',
      'required' => array('header-template', 'equals', array('header-style3')),
    ),
    array(
      'id'       => 'header-location',
      'type'     => 'text',
      'title'    => esc_html__('Location', 'luxe'),
      'default'  => '3655 S Las Vegas Blvd, Paris',
      'required' => array('header-template', 'equals', array('header-style3')),
    ),
    array(
      'id'       => 'random-number-social',
      'type'     => 'info',
      'desc'     => wp_kses_post('<h2 style="color:#0073aa;">Social Icons</h2>'),
      'required' => array('header-template', 'equals', array('header-style3')),
    ),
    array(
      'id'       => 'header-social-icons-category',
      'type'     => 'select',
      'title'    => esc_html__('Social Icons Category', 'luxe'),
      'subtitle' => esc_html__('Select desired category', 'luxe'),
      'options'  => luxe_get_terms_assoc('social-site-category'),
      'default'  => '',
      'required' => array('header-template', 'equals', array('header-style3')),
    ),
    array(
      'id'   => 'random-number',
      'type' => 'info',
      'desc' => wp_kses_post('<h2 style="color:#0073aa;">Button Module</h2>')
    ),
    array(
      'id' => 'header-btn-enable-switch',
      'type' => 'switch',
      'title' => esc_html__('Enable Button', 'luxe'),
      'options' => array(
        '1' => 'On',
        '0' => 'Off',
      ),
      'default' => '0',
      'subtitle' => esc_html__('If on, this layout part will be displayed.', 'luxe'),
    ),
    array(
      'id'       =>'header-btn-text',
      'type'     => 'text',
      'title'    => esc_html__('Button Text', 'luxe'),
      'default'  => esc_html__('Book Now', 'luxe')
    ),
    array(
      'id'       =>'header-btn-link',
      'type'     => 'text',
      'title'    => esc_html__('Button Link', 'luxe'),
      'default'  => esc_html__('#', 'luxe'),
    ),
    array(
      'id'      => 'customizer-header-btn-bg-color',
      'type'    => 'color',
      'title'   => esc_html__('Button Background Color', 'luxe'),
      'default' => '',
      'transparent' => false,
      'output'  => array('background' => '.header-btn')
    ),
    array(
      'id'      => 'customizer-header-btn-bg-color-hover',
      'type'    => 'color',
      'title'   => esc_html__('Button Background Hover Color', 'luxe'),
      'default' => '',
      'transparent' => false,
      'output'  => array('background' => '.header-btn:hover')
    ),
    array(
      'id'      => 'customizer-header-btn-text-color',
      'type'    => 'color',
      'title'   => esc_html__('Button Text Color', 'luxe'),
      'default' => '',
      'transparent' => false,
      'output'  => array('color' => '.header-btn')
    ),
    array(
      'id'      => 'customizer-header-btn-text-color-hover',
      'type'    => 'color',
      'title'   => esc_html__('Button Text Hover Color', 'luxe'),
      'default' => '',
      'transparent' => false,
      'output'  => array('color' => '.header-btn:hover')
    ),
    array(
      'id' => 'random-number',
      'type' => 'info',
      'desc' => '<h2 style="color:#0073aa;">'.esc_html__('Header Color Settings', 'luxe').'</h2>'
    ),
    array(
      'id'      => 'customizer-header-bg-color',
      'type'    => 'color',
      'title'   => esc_html__('Header Background Color', 'luxe'),
      'default' => '',
      'transparent' => false,
      'output'  => array('background' => '.nav-bar', 'border-color' => '.nav-bar')
    ),
    array(
      'id'      => 'customizer-header-icon-color',
      'type'    => 'color',
      'title'   => esc_html__('Header Icon Color', 'luxe'),
      'default' => '',
      'transparent' => false,
      'output'  => array('color' => '.above-menu__item i')
    ),
    array(
      'id'      => 'customizer-header-icon-color-hover',
      'type'    => 'color',
      'title'   => esc_html__('Header Icon Hover Color', 'luxe'),
      'default' => '',
      'transparent' => false,
      'output'  => array('color' => '.above-menu__item i:hover')
    ),
    array(
      'id'      => 'customizer-header-text-color',
      'type'    => 'color',
      'title'   => esc_html__('Header Text Color', 'luxe'),
      'default' => '',
      'transparent' => false,
      'output'  => array('color' => '.above-menu__item')
    ),
    array(
      'id'      => 'customizer-header-text-link-color',
      'type'    => 'color',
      'title'   => esc_html__('Header Text Link Color', 'luxe'),
      'default' => '',
      'transparent' => false,
      'output'  => array('color' => '.above-menu__item a')
    ),
    array(
      'id'      => 'customizer-header-text-link-color-hover',
      'type'    => 'color',
      'title'   => esc_html__('Header Text Link Hover Color', 'luxe'),
      'default' => '',
      'transparent' => false,
      'output'  => array('color' => '.above-menu__item a:hover')
    ),

    array(
      'id'       => 'random-number-above-menu',
      'type'     => 'info',
      'desc'     => '<h3 style="color:#0073aa;">'.esc_html__('Above Menu Header Color Settings', 'luxe').'</h3>',
      'required' => array('header-template', 'equals', array('header-style3')),
    ),
    array(
      'id'       => 'customizer-above-menu-header-bg-color',
      'type'     => 'color',
      'title'    => esc_html__('Above Header Background Color', 'luxe'),
      'default'  => '',
      'transparent' => false,
      'output'   => array('background' => '.above-menu', 'border-color' => '.above-menu'),
      'required' => array('header-template', 'equals', array('header-style3')),
    ),
  ), // #fields
);
