<?php
/*
 * Footer Section
*/
$this->sections[] = array(
  'title' => esc_html__('Footer', 'luxe'),
  'desc' => esc_html__('Change the footer section configuration.', 'luxe'),
  'icon' => 'fa fa-list-alt',
  'fields' => array(

    array(
      'id'    => 'footer-enable-switch',
      'type'  => 'switch',
      'title' => esc_html__('Enable Footer', 'luxe'),
      'options' => array(
        '1' => 'On',
        '0' => 'Off',
      ),
      'default' => '1',
      'subtitle' => esc_html__('If on, this layout part will be displayed.', 'luxe'),
    ),
    array(
      'id'        => 'footer-column',
      'type'      => 'select',
      'compiler'  => true,
      'title'     => esc_html__('Footer Columns', 'luxe'),
      'subtitle'  => esc_html__('Select footer column.', 'luxe'),
      'options'   => array(
        '4' => esc_html__('Column 4', 'luxe'),
        '3' => esc_html__('Column 3', 'luxe'),
        '2' => esc_html__('Column 2', 'luxe'),
        '1' => esc_html__('Column 1', 'luxe'),
      ),
      'default'   => '4',
    ),
    array(
      'id'        => 'footer-sidebar-1',
      'type'      => 'select',
      'title'     => esc_html__('Footer Sidebar 1', 'luxe'),
      'subtitle'  => esc_html__('Select custom sidebar', 'luxe'),
      'options'   => luxe_get_custom_sidebars_list(),
      'default'   => '',
      'required'  => array('footer-column', 'equals', array('4', '3', '2', '1')),
    ),
    array(
      'id'        => 'footer-sidebar-2',
      'type'      => 'select',
      'title'     => esc_html__('Footer Sidebar 2', 'luxe'),
      'subtitle'  => esc_html__('Select custom sidebar', 'luxe'),
      'options'   => luxe_get_custom_sidebars_list(),
      'default'   => '',
      'required'  => array('footer-column', 'equals', array('4', '3', '2')),
    ),
    array(
      'id'        => 'footer-sidebar-3',
      'type'      => 'select',
      'title'     => esc_html__('Footer Sidebar 3', 'luxe'),
      'subtitle'  => esc_html__('Select custom sidebar', 'luxe'),
      'options'   => luxe_get_custom_sidebars_list(),
      'default'   => '',
      'required'  => array('footer-column', 'equals', array('4', '3')),
    ),
    array(
      'id'        => 'footer-sidebar-4',
      'type'      => 'select',
      'title'     => esc_html__('Footer Sidebar 4', 'luxe'),
      'subtitle'  => esc_html__('Select custom sidebar', 'luxe'),
      'options'   => luxe_get_custom_sidebars_list(),
      'default'   => '',
      'required'  => array('footer-column', 'equals', array('4')),
    ),
    array(
      'id' => 'random-number',
      'type' => 'info',
      'desc' => '<h2 style="color:#0073aa;">'.esc_html__('Footer Color Settings', 'luxe').'</h2>'
    ),
    array(
      'id'      => 'customizer-footer-bg-color',
      'type'    => 'color',
      'title'   => esc_html__('Footer Background Color', 'luxe'),
      'default' => '',
      'transparent' => false,
      'output'  => array('background' => '.site-footer')
    ),
    array(
      'id'      => 'customizer-footer-widget-title-color',
      'type'    => 'color',
      'title'   => esc_html__('Footer Widget Title Color', 'luxe'),
      'default' => '',
      'transparent' => false,
      'output'  => array('color' => '.site-footer .widget-title')
    ),
    array(
      'id'      => 'customizer-footer-text-color',
      'type'    => 'color',
      'title'   => esc_html__('Footer Text Color', 'luxe'),
      'default' => '',
      'transparent' => false,
      'output'  => array('color' => '.site-footer__main')
    ),
    array(
      'id'      => 'customizer-footer-link-color',
      'type'    => 'color',
      'title'   => esc_html__('Footer Link Color', 'luxe'),
      'default' => '',
      'transparent' => false,
      'output'  => array('color' => '.site-footer .site-footer__main a')
    ),
    array(
      'id'      => 'customizer-footer-link-hover-color',
      'type'    => 'color',
      'title'   => esc_html__('Footer Link Hover Color', 'luxe'),
      'default' => '',
      'transparent' => false,
      'output'  => array('color' => '.site-footer .site-footer__main a:hover')
    ),
    array(
      'id'      => 'customizer-footer-icon-color',
      'type'    => 'color',
      'title'   => esc_html__('Footer Icon Color', 'luxe'),
      'default' => '',
      'transparent' => false,
      'output'  => array('color' => '.site-footer .contact-info i')
    ),
    array(
      'id' => 'random-number',
      'type' => 'info',
      'desc' => '<h2 style="color:#0073aa;">'.esc_html__('Copyright Module', 'luxe').'</h2>'
    ),
    array(
      'id'    =>'footer-copyright-text',
      'type'  => 'text',
      'title' => esc_html__('Copyright Text', 'luxe'),
    ),
    array(
      'id'      => 'customizer-copyright-bg-color',
      'type'    => 'color',
      'title'   => esc_html__('Copyright Background Color', 'luxe'),
      'default' => '',
      'transparent' => false,
      'output'  => array('background' => '.site-footer__copyright')
    ),
    array(
      'id'      => 'customizer-copyright-text-color',
      'type'    => 'color',
      'title'   => esc_html__('Copyright Text Color', 'luxe'),
      'default' => '',
      'transparent' => false,
      'output'  => array('color' => '.site-footer__copyright')
    ),
  ), // #fields
);
