<?php
/**
 * Latest posts widget
 *
 * @package hotelbay
 */

class hotelbay_WP_Newsletter_Widget extends WP_Widget
{
    function __construct()
    {
        $widget_ops = array('classname' => 'widget_newsletter_entries', 'description' => __( "Add newsletter", 'hotelbay-addons' ) );
        parent::__construct('subscribe-widget', __( '- luxe: Newsletter', 'hotelbay-addons' ), $widget_ops);

        $this-> alt_option_name = 'widget_newsletter_entries';

        add_action( 'save_post', array(&$this, 'flush_widget_cache') );
        add_action( 'deleted_post', array(&$this, 'flush_widget_cache') );
        add_action( 'switch_theme', array(&$this, 'flush_widget_cache') );
    }

    function widget($args, $instance)
    {
        global $post;

        $cache = wp_cache_get('widget_newsletter_entries', 'widget');

        if ( !is_array($cache) )
        {
            $cache = array();
        }
        if ( ! isset( $args['widget_id'] ) )
        {
            $args['widget_id'] = $this->id;
        }

        if ( isset( $cache[ $args['widget_id'] ] ) )
        {
            echo $cache[ $args['widget_id'] ];
            return;
        }

        ob_start();
        extract($args);
        echo $before_widget;

        $title = apply_filters('widget_title', $instance['title'], $instance, $this->id_base);
        if ($title):
            echo $before_title.esc_html($title).$after_title;
        endif; 
        if(function_exists('newsletter_form')):
        ?>

        <div class="tnp tnp-widget">
          <form method="post" action="<?php echo esc_url(home_url('/')); ?>?na=s" onsubmit="return newsletter_check(this)">
            <div class="tnp-field tnp-field-email">
              <label>Email</label>
              <input class="tnp-email" type="email" name="ne" required="" placeholder="Your email">
            </div>
            <div class="tnp-field tnp-field-button">
              <input class="tnp-submit newsletter-submit" type="submit" value="Sign up now">
            </div>
          </form>
        </div>
        <?php endif; ?>
        <?php echo $after_widget;
        $cache[$args['widget_id']] = ob_get_flush();
        wp_cache_set('widget_newsletter_entries', $cache, 'widget');
    }

    function update( $new_instance, $old_instance )
    {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $this->flush_widget_cache();

        $alloptions = wp_cache_get( 'alloptions', 'options' );
        if ( isset($alloptions['widget_newsletter_entries']) )
        {
            delete_option('widget_newsletter_entries');
        }
        return $instance;
    }

    function flush_widget_cache()
    {
        wp_cache_delete('widget_newsletter_entries', 'widget');
    }

    function form( $instance )
    {
        $title   = isset($instance['title']) ? $instance['title'] : '';
        ?>
        <p><label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php _e( 'Title:', 'hotelbay-addons' ); ?></label>
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>
       
        <?php
    }
}
