<?php
/**
 *
 * RS Image Block
 * @since 1.0.0
 * @version 1.0.0
 *
 *
 */
function rs_text_block_with_button( $atts, $content = '', $id = '' ) {

  extract( shortcode_atts( array(
    'id'            => '',
    'class'         => '',
    'btn_text'      => '',
    'btn_link'      => '',
    'small_heading' => '',
    'big_heading'   => '',
  ), $atts ) );

  $id    = ( $id ) ? ' id="'. esc_attr($id) .'"' : '';
  $class = ( $class ) ? ' '. luxe_sanitize_html_classes($class) : '';

  if (function_exists('vc_parse_multi_attribute')) {
    $parse_args = vc_parse_multi_attribute($btn_link);
    $href       = ( isset($parse_args['url']) ) ? $parse_args['url'] : '#';
    $title      = ( isset($parse_args['title']) ) ? $parse_args['title'] : 'button';
    $target     = ( isset($parse_args['target']) ) ? trim($parse_args['target']) : '_self';
  }


  $output  =  '<div '.$id.' class="subtitle subtitle--left subtitle--sm'.$class.'">'.esc_html($small_heading).'</div>';
  $output .=  '<div class="title title--left title-color-black title--sm">'.esc_html($big_heading).'</div>';
  $output .=  '<div class="spacing" style="height: 25px"></div>';
  $output .=  '<div class="text">';
  $output .=  '<p>'.wp_kses_post($content).'</p>';
  $output .=  '</div>';
  $output .=  '<div class="spacing" style="height: 15px"></div>';
  if(!empty($btn_link)):
    $output .=  '<a class="btn mb-0 btn--md btn--normal" href="'.esc_url($href).'" title="'.esc_attr($title).'" target="'.esc_attr($target).'">'.esc_html($btn_text).'</a>';
  endif;

  return $output;
}

add_shortcode('rs_text_block_with_button', 'rs_text_block_with_button');
