<?php
/**
 *
 * RS Special Text
 * @since 1.0.0
 * @version 1.0.0
 *
 *
 */
function rs_special_text( $atts, $content = '', $id = '' ) {

  extract( shortcode_atts( array(
    'id'             => '',
    'class'          => '',
    'font'           => 'default',
    'tag'            => 'div',
    'font_size'      => '',
    'font_weight'    => '300',
    'font_style'     => '',
    'margin_top'     => '',
    'margin_bottom'  => '',
    'line_height'    => '',
    //'css'            => '',
    'align'          => '',
    'font_color'     => '',
    'transform'      => '',
    'letter_spacing' => ''

  ), $atts ) );

  $id     = ( $id ) ? ' id="'. esc_attr($id) .'"' : '';
  $class  = ( $class ) ? ' '. sanitize_html_classes($class) : '';
  $output = '';
  if(strpos($font, 'google') !== false) {
    $font_weight_type = ($font_style == 'italic' && $font_weight ) ? $font_weight.'i':$font_weight;
    $ifont_name  = str_replace('google_web_font_', '', $font);
    $font_name  = str_replace(' ', '+', $ifont_name);
    $output .=  "<link href='http://fonts.googleapis.com/css?family=".esc_attr($font_name).":".esc_attr($font_weight_type)."' rel='stylesheet' type='text/css'>";
  } else {
    $ifont_name = $font;
  }

 
  $font_family_attr         = ($font != 'default' ) ? ' font-family:'.esc_attr($ifont_name).', san-serif;':'';
  $font_size_attr           = ($font_size) ? ' font-size:'.esc_attr($font_size).';':'';
  $font_weight_attr         = ($font_weight) ? ' font-weight:'.esc_attr($font_weight).';':'';
  $font_style_attr          = ($font_style) ? ' font-style:'.esc_attr($font_style).';':'';
  $font_line_height_attr    = ($line_height) ? ' line-height:'.esc_attr($line_height).';':'';
  $font_align_attr          = ($align) ? ' text-align:'.esc_attr($align).';':'';
  $font_color_attr          = ($font_color) ? ' color:'.esc_attr($font_color).';':'';
  $font_transform_attr      = ($transform) ? ' text-transform:'.esc_attr($transform).';':'';
  $font_letter_spacing_attr = ($letter_spacing) ? ' letter-spacing:'.esc_attr($letter_spacing).';':'';
  $margin_top_attr          = ($margin_top) ? ' margin-top:'.esc_attr($margin_top).';':'';
  $margin_bottom_attr       = ($margin_bottom) ? ' margin-bottom:'.esc_attr($margin_bottom).';':'';

  $style_attr = ($font_family_attr || $font_size_attr || $font_weight_attr || $font_style_attr || $font_line_height_attr || $font_align_attr || $font_color_attr || $font_transform_attr || $font_letter_spacing_attr || $margin_top_attr || $margin_bottom_attr) ? ' style="'.$font_family_attr.$font_size_attr.$font_weight_attr.$font_style_attr.$font_line_height_attr.$font_align_attr.$font_color_attr.$font_transform_attr.$font_letter_spacing_attr.$margin_top_attr.$margin_bottom.'"':'';

  $output .= '<'.esc_html($tag).' '.$id.' class="'.$class.'special-text"'.$style_attr.'>';
  $output .= rs_set_wpautop($content);
  $output .=  '</'.esc_html($tag).'>';

  return $output;
}

add_shortcode('rs_special_text', 'rs_special_text');
