<?php
/**
 *
 * RS Image Block
 * @since 1.0.0
 * @version 1.0.0
 *
 *
 */
function rs_image_block( $atts, $content = '', $id = '' ) {

  extract( shortcode_atts( array(
    'id'     => '',
    'class'  => '',
    'image'  => '',
  ), $atts ) );

  $id    = ( $id ) ? ' id="'. esc_attr($id) .'"' : '';
  $class = ( $class ) ? ' '. luxe_sanitize_html_classes($class) : '';

  $output = '';
  $image_src = rs_get_image_src($image);
  if (!empty( $image_src ) ) {
    $output .=  '<img '.$id.' class="img-responsive  '.$class.'" src="'.esc_url($image_src).'" alt="">';
  }

  return $output;
}

add_shortcode('rs_image_block', 'rs_image_block');
