<?php
/**
 *
 * RS Space
 * @since 1.0.0
 * @version 1.0.0
 *
 */
function rs_icon_box( $atts, $content = '', $id = '' ) {

  extract( shortcode_atts( array(
    'id'            => '',
    'class'         => '',
    'img_icon'      => '',
    'icon_box_link' => '',
    'heading'       => '',
    'bg_img_hover'  => ''
  ), $atts ) );

  $id            = ( $id ) ? ' id="'. esc_attr($id) .'"' : '';
  $class         = ( $class ) ? ' '. luxe_sanitize_html_classes($class) : '';
  $img_icon_html = $img_bg_html =  '';

  if (function_exists('vc_parse_multi_attribute')) {
    $parse_args = vc_parse_multi_attribute($icon_box_link);
    $href       = ( isset($parse_args['url']) ) ? $parse_args['url'] : '#';
    $btn_title  = ( isset($parse_args['title']) ) ? $parse_args['title'] : 'button';
    $target     = ( isset($parse_args['target']) ) ? trim($parse_args['target']) : '_self';
  }

  if(!empty($img_icon) && is_numeric($img_icon)) {
    $image_src = wp_get_attachment_image_src( $img_icon, 'full' );
    if(isset($image_src[0])) {
      $img_icon_html .=  '<img src="'.esc_url($image_src[0]).'" alt="">';
    }
  }

  if(!empty($bg_img_hover) && is_numeric($bg_img_hover)) {
    $image_src_bg = wp_get_attachment_image_src( $bg_img_hover, 'full' );
    if(isset($image_src_bg[0])) {
      $img_bg_html .=  '<img class="icon__background" src="'.esc_url($image_src_bg[0]).'" alt="">';
    }
  }

  $output  =  '<a '.$id.' href="'.esc_url($href).'" title="'.esc_html($btn_title).'" target="'.esc_attr($target).'" class="icon mb-0 mt-0 icon--style-1'.$class.'">';
  $output .= '<div class="icon__wrapper">';
  $output .=  '<div class="icon__front">';
  $output .=  '<div class="icon__wrap">';
  $output .=  '<div class="icon__media">';
  $output .=  $img_icon_html;
  $output .=  '</div>';
  $output .=  '<h3 class="icon__title">'.esc_html($heading).'</h3>';
  $output .=  '<div class="icon__text">'.wp_kses_post($content).'</div>';
  $output .=  '</div>';
  $output .=  '</div>';
  $output .= '<div class="icon__back">';
  $output .=  $img_bg_html;
  $output .=  '</div>';
  $output .=  '</div>';
  $output .=  '</a><div class="empty-space marg-xs-b15"></div>';


  // $output  =  '<a '.$id.' href="'.esc_url($href).'" title="'.esc_html($btn_title).'" target="'.esc_attr($target).'" class="icon mb-0 mt-0 icon--style-1'.$class.'">';
  // $output .=  '<div class="icon__wrap">';
  // $output .=  '<div class="icon__media">';
  // $output .=  $img_icon_html;
  // $output .=  '</div>';
  // $output .=  '<h3 class="icon__title">'.esc_html($heading).'</h3>';
  // $output .=  '<div class="icon__text">'.wp_kses_post($content).'</div>';
  // $output .=  '</div>';
  // $output .=  $img_bg_html;
  // $output .=  '</a><div class="empty-space marg-xs-b15"></div>';

  return $output;
}

add_shortcode('rs_icon_box', 'rs_icon_box');
