<?php
/**
 *
 * RS Check List
 * @since 1.0.0
 * @version 1.0.0
 *
 *
 */
function rs_check_list( $atts, $content = '', $id = '' ) {

  extract( shortcode_atts( array(
    'id'    => '',
    'class' => '',
    'list'  => ''
  ), $atts ) );

  $id        = ( $id ) ? ' id="'. esc_attr($id) .'"' : '';
  $class     = ( $class ) ? ' '. luxe_sanitize_html_classes($class) : '';
  $list_data = array();
  $list_item = (array) vc_param_group_parse_atts( $list );

  foreach ($list_item as $key => $value) {
    $new_data = $value;
    $new_data['list_item'] = isset( $value['list_item'] ) ? $value['list_item'] : '';
    $list_data[] = $new_data;
  }
  
  $output  =  '<ul '.$id.' class="list mb-0 list--check'.$class.'">';
  foreach ($list_data as $new_value) {
    $output .=  '<li class="list__item">'.esc_html($new_value['list_item']).'</li>';
  }
  $output .=  '</ul>';
  return $output;

}
add_shortcode('rs_check_list', 'rs_check_list');
