<?php
include_once( RS_ROOT .'/composer/params.php' );
if ( ! function_exists( 'is_plugin_active' ) ) {
  include_once( ABSPATH . 'wp-admin/includes/plugin.php' ); // Require plugin.php to use is_plugin_active() below
}

$vc_map_extra_id = array(
  'type'        => 'textfield',
  'heading'     => 'Extra ID',
  'param_name'  => 'id',
  'group'       => 'Extras'
);

$vc_map_extra_class = array(
  'type'        => 'textfield',
  'heading'     => 'Extra Class',
  'param_name'  => 'class',
  'group'       => 'Extras'
);

$vc_post_meta_category = array(
  'type'        => 'dropdown',
  'heading'     => 'Show Category ?',
  'param_name'  => 'show_category',
  'value'       => array(
    'Yes' => 'yes',
    'No' => 'no',
  ),
);

$vc_post_meta_author = array(
  'type'        => 'dropdown',
  'heading'     => 'Show Author ?',
  'param_name'  => 'show_author',
  'value'       => array(
    'Yes' => 'yes',
    'No' => 'no',
  ),
);

$vc_post_meta_date = array(
  'type'        => 'dropdown',
  'heading'     => 'Show Date ?',
  'param_name'  => 'show_date',
  'value'       => array(
    'Yes' => 'yes',
    'No' => 'no',
  ),
);

$vc_post_meta_comment = array(
  'type'        => 'dropdown',
  'heading'     => 'Show Comment ?',
  'param_name'  => 'show_comment',
  'value'       => array(
    'Yes' => 'yes',
    'No' => 'no',
  ),
);

$vc_post_meta_views = array(
  'type'        => 'dropdown',
  'heading'     => 'Show Views ?',
  'param_name'  => 'show_views',
  'value'       => array(
    'Yes' => 'yes',
    'No' => 'no',
  ),
);

vc_map( array(
  'name'        => 'Blog',
  'base'        => 'rs_blog',
  'category'    => 'Hotel Bay Elements',
  'icon'        => 'fa fa-comments',
  'description' => 'Create a blog.',
  'params'          => array(
    array(
      'type'        => 'vc_efa_chosen',
      'heading'     => 'Select Categories',
      'param_name'  => 'cats',
      'placeholder' => 'Select category',
      'value'       => rs_element_values( 'categories', array(
        'sort_order'  => 'ASC',
        'taxonomy'    => 'category',
        'hide_empty'  => false,
      ) ),
      'std'         => '',
      'description' => 'You can choose specific categories for blog, default is all categories.',
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Post Per Page',
      'param_name'  => 'post_per_page',
      'description' => 'Post Per Page',
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Excerpt',
      'param_name'  => 'excerpt_length',
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Exclude Post',
      'param_name'  => 'exclude_posts',
      'description' => 'Add Post ID to exclude for e.g 345,268'
    ),
    $vc_post_meta_category,
    $vc_post_meta_author,
    array(
      'type'        => 'dropdown',
      'admin_label' => true,
      'heading'     => 'Order by',
      'param_name'  => 'orderby',
      'value'       => array(
        'ID'            => 'ID',
        'Author'        => 'author',
        'Post Title'    => 'title',
        'Date'          => 'date',
        'Last Modified' => 'modified',
        'Random Order'  => 'rand',
        'Comment Count' => 'comment_count',
        'Menu Order'    => 'menu_order',
      ),
    ),
    // Extras
    $vc_map_extra_id,
    $vc_map_extra_class,
  ),
) );

vc_map( array(
  'name'          => 'Buttons',
  'base'          => 'rs_button',
  'category'      => 'Hotel Bay Elements',
  'icon'          => 'fa fa-square',
  'description'   => 'Create a classy button.',
  'params'        => array(
    array(
      'type'        => 'dropdown',
      'heading'     => 'Type',
      'param_name'  => 'type',
      'value'       => array(
        'Solid' => 'soild',
        'Text'  => 'text'
      ),
    ),
    array(
      'type'        => 'dropdown',
      'heading'     => 'Align',
      'param_name'  => 'align',
      'value'       => array(
        'Select Align' => '',
        'Left'   => 'left',
        'Center' => 'center',
        'Right'  => 'right',
      ),
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Button Text',
      'param_name'  => 'btn_text',
      'admin_label' => true,
    ),
    array(
      'type'        => 'vc_link',
      'heading'     => 'Button Link',
      'param_name'  => 'btn_link',
      'admin_label' => true,
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Font Size',
      'param_name'  => 'font_size',
      'admin_label' => true,
      'description' => 'for e.g 14px',
      'group'       => 'Custom Properties'
    ),
    array(
      'type'             => 'textfield',
      'heading'          => 'Padding Top',
      'admin_label'      => true,
      'edit_field_class' => 'vc_col-md-3 vc_column',
      'param_name'       => 'padding_top',
      'description'      => 'for e.g 14px',
      'group'            => 'Custom Properties'
    ),
    array(
      'type'             => 'textfield',
      'heading'          => 'Padding Left',
      'admin_label'      => true,
      'edit_field_class' => 'vc_col-md-3 vc_column',
      'param_name'       => 'padding_left',
      'description'      => 'for e.g 14px',
      'group'            => 'Custom Properties'
    ),    
    array(
      'type'             => 'textfield',
      'heading'          => 'Padding Bottom',
      'admin_label'      => true,
      'edit_field_class' => 'vc_col-md-3 vc_column',
      'param_name'       => 'padding_bottom',
      'description'      => 'for e.g 14px',
      'group'            => 'Custom Properties'
    ),
    array(
      'type'             => 'textfield',
      'heading'          => 'Padding Right',
      'edit_field_class' => 'vc_col-md-3 vc_column',
      'admin_label'      => true,
      'param_name'       => 'padding_right',
      'description'      => 'for e.g 14px',
      'group'            => 'Custom Properties'
    ),
    array(
      'type'        => 'colorpicker',
      'heading'     => 'Background Color',
      'admin_label' => true,
      'param_name'  => 'bg_color',
      'group'       => 'Custom Properties'
    ),
    array(
      'type'        => 'colorpicker',
      'heading'     => 'Text Color',
      'admin_label' => true,
      'param_name'  => 'text_color',
      'group'       => 'Custom Properties'
    ),

    // Extras
    $vc_map_extra_id,
    $vc_map_extra_class,

  )
) );

vc_map( array(
  'name'          => 'Testimonial',
  'base'          => 'rs_testimonial',
  'category'      => 'Hotel Bay Elements',
  'icon'          => 'fa fa-comments',
  'description'   => 'Create a testimonial block.',
  'params'        => array(
    array(
      'type'        => 'vc_efa_chosen',
      'heading'     => 'Category ID',
      'param_name'  => 'cats',
      'value'       => rs_get_custom_term_values('testimonial-category'),
      'std'         => '',
      'placeholder' => 'Choose Category',
      'admin_label' => true,
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Limit',
      'param_name'  => 'limit',
    ),

    $vc_map_extra_id,
    $vc_map_extra_class,
  )
) );

vc_map( array(
  'name'          => 'Image Block',
  'base'          => 'rs_image_block',
  'category'      => 'Hotel Bay Elements',
  'icon'          => 'fa fa-image',
  'description'   => 'Add image.',
  'params'        => array(
    array(
      'type'       => 'dropdown',
      'heading'    => 'Align',
      'param_name' => 'align',
      'value'      => array(
        'Left'   => 'left-block',
        'Center' => 'center-block',
      ),
    ),
    array(
      'type'       => 'dropdown',
      'heading'    => 'Shadow',
      'param_name' => 'shadow',
      'value'      => array(
        'Yes' => 'yes',
        'No'  => 'no',
      ),
    ),
    array(
      'type'        => 'attach_image',
      'heading'     => 'Image',
      'admin_label' => true,
      'param_name'  => 'image',
    ),
    $vc_map_extra_id,
    $vc_map_extra_class,
  )
) );

vc_map( array(
  'name'        => 'Pricing Table',
  'base'        => 'rs_pricing_table',
  'category'    => 'Hotel Bay Elements',
  'icon'        => 'fa fa-dollar',
  'description' => 'Create a pricing table.',
  'params'  => array(
    array(
      'type'        => 'textfield',
      'heading'     => 'Plan',
      'param_name'  => 'plan',
      'value'       => '',
      'admin_label' => true,
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Duration',
      'param_name'  => 'duration',
      'value'       => '',
      'description' => 'For example mo or year',
      'admin_label' => true,
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Currency',
      'param_name'  => 'currency',
      'value'       => '',
      'admin_label' => true,
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Price',
      'param_name'  => 'price',
      'admin_label' => true,
      'value'       => '',
    ),
    array(
      'type'        => 'textarea',
      'heading'     => 'Feature',
      'value'       => '',
      'param_name'  => 'feature',
      'admin_label' => true,
      'description' => 'Add feature seperated with |'
    ),

    // Extras
    $vc_map_extra_id,
    $vc_map_extra_class,
  ),

) );

vc_map( array(
  'name'          => 'Featured Animities Banner',
  'base'          => 'rs_featured_animities_banner',
  'category'      => 'Hotel Bay Elements',
  'icon'          => 'fa fa-image',
  'description'   => 'Add featured animities banner.',
  'params'        => array(
    array(
      'type'        => 'dropdown',
      'heading'     => 'Style',
      'param_name'  => 'style',
      'value'       => array(
        'Style 1'   => 'style1',
        'Style 2'   => 'style2'
      ),
    ),
    array(
      'type'        => 'attach_image',
      'heading'     => 'Banner Image',
      'param_name'  => 'banner_image',
      'value'       => ''
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Heading',
      'param_name'  => 'heading',
      'holder'      => 'h3',
      'value'       => ''
    ),
    array(
      'type'        => 'textarea_html',
      'heading'     => 'Content',
      'param_name'  => 'content',
      'holder'      => 'p',
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Button Text',
      'param_name'  => 'btn_text',
      'admin_label' => true,
    ),
    array(
      'type'        => 'vc_link',
      'heading'     => 'Button Link',
      'param_name'  => 'btn_link',
      'admin_label' => true,
    ),
    array(
      'type'        => 'colorpicker',
      'heading'     => 'Background Color',
      'param_name'  => 'bg_color',
      'group'       => 'Custom Color Properties',
      'admin_label' => true,
    ),
    array(
      'type'        => 'colorpicker',
      'heading'     => 'Heading Color',
      'param_name'  => 'heading_color',
      'admin_label' => true,
      'group'       => 'Custom Color Properties',
    ),
    array(
      'type'        => 'colorpicker',
      'heading'     => 'Content Color',
      'param_name'  => 'content_color',
      'admin_label' => true,
      'group'       => 'Custom Color Properties',
    ),
    $vc_map_extra_id,
    $vc_map_extra_class,
  )
) );

vc_map( array(
  'name'          => 'Text Block with Button',
  'base'          => 'rs_text_block_with_button',
  'category'      => 'Hotel Bay Elements',
  'icon'          => 'fa fa-image',
  'description'   => 'Add text block with button.',
  'params'        => array(
    array(
      'type'        => 'textfield',
      'heading'     => 'Small Heading',
      'param_name'  => 'small_heading',
      'holder'      => 'h5',
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Big Heading',
      'param_name'  => 'big_heading',
      'holder'      => 'h2',
    ),
    array(
      'type'        => 'textarea_html',
      'heading'     => 'Content',
      'param_name'  => 'content',
      'holder'      => 'div',
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Button Text',
      'param_name'  => 'btn_text',
      'admin_label' => true,
    ),
    array(
      'type'        => 'vc_link',
      'heading'     => 'Button Link',
      'param_name'  => 'btn_link',
      'admin_label' => true,
    ),
    $vc_map_extra_id,
    $vc_map_extra_class,
  )
) );

vc_map( array(
  'name'          => 'Divider',
  'base'          => 'rs_divider',
  'category'      => 'Hotel Bay Elements',
  'icon'          => 'fa fa fa-arrows-v',
  'description'   => 'Add divider.',
  'params'        => array(
    array(
      'type'        => 'textfield',
      'heading'     => 'Margin Top',
      'admin_label' => true,
      'param_name'  => 'margin_top',
      'description' => 'All values are in px'
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Margin Bottom',
      'admin_label' => true,
      'param_name'  => 'margin_bottom',
      'description' => 'All values are in px'
    ),
    array(
      'type'        => 'colorpicker',
      'heading'     => 'Border Color',
      'admin_label' => true,
      'param_name'  => 'border_color',
    ),

    $vc_map_extra_id,
    $vc_map_extra_class,
  )
) );


vc_map( array(
  'name'          => 'Gallery',
  'base'          => 'rs_image_gallery',
  'category'      => 'Hotel Bay Elements',
  'icon'          => 'fa fa-image',
  'description'   => 'Add image gallery.',
  'params'        => array(
    array(
      'type'        => 'textfield',
      'heading'     => 'Title',
      'param_name'  => 'title',
    ),
    array(
      'type'        => 'attach_images',
      'heading'     => 'Images',
      'admin_label' => true,
      'param_name'  => 'images',
    ),
    $vc_map_extra_id,
    $vc_map_extra_class,
  )
) );

vc_map( array(
  'name'          => 'Special Text',
  'category'      => 'Hotel Bay Elements',
  'base'          => 'rs_special_text',
  'icon'          => 'fa fa-image',
  'description'   => 'Create special text.',
  'params'        => array(
    array(
      'type'        => 'dropdown',
      'heading'     => 'Font',
      'param_name'  => 'font',
      'admin_label' => true,
      'value'       => array_flip(rs_get_font_choices(true)),
    ),
    array(
      'type'        => 'dropdown',
      'heading'     => 'Tag Name',
      'param_name'  => 'tag',
      'value'       => array(
        'div' => 'div',
        'H1'  => 'h1',
        'H2'  => 'h2',
        'H3'  => 'h3',
        'H4'  => 'h4',
        'H5'  => 'h5',
        'H6'  => 'h6',
      ),
    ),
    array(
      'type'        => 'textarea_html',
      'heading'     => 'Content',
      'param_name'  => 'content',
      'holder'      => 'div',
    ),
    array(
      'type'        => 'dropdown',
      'heading'     => 'Align',
      'param_name'  => 'align',
      'value'       => array(
        'Select Align' => '',
        'Left'   => 'left',
        'Center' => 'center',
        'Right'  => 'right',
      ),
      'group'       => 'Custom Font Properties'
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Font Size',
      'param_name'  => 'font_size',
      'description' => 'Enter the size in pixel e.g 45px',
      'group'       => 'Custom Font Properties'
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Line Height',
      'param_name'  => 'line_height',
      'group'       => 'Custom Font Properties'
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Letter Spacing',
      'param_name'  => 'letter_spacing',
      'description' => 'Enter the size in pixel e.g 1px',
      'group'       => 'Custom Font Properties'
    ),
    array(
      'type'        => 'colorpicker',
      'heading'     => 'Font Color',
      'param_name'  => 'font_color',
      'group'       => 'Custom Font Properties'
    ),
    array(
      'type'        => 'dropdown',
      'heading'     => 'Font Weight',
      'param_name'  => 'font_weight',
      'value'       => array(
        'Light'      => '300',
        'Normal'     => '400',
        'Bold'       => '600',
        'Bold'       => '700',
        'Extra Bold' => '800',
      ),
      'group'       => 'Custom Font Properties'
    ),
    array(
      'type'        => 'dropdown',
      'heading'     => 'Font Style',
      'param_name'  => 'font_style',
      'value'       => array(
        'Normal' => 'normal',
        'Italic' => 'italic',
      ),
      'group'       => 'Custom Font Properties'
    ),
    array(
      'type'        => 'dropdown',
      'heading'     => 'Text Transform',
      'param_name'  => 'transform',
      'value'       => array(
        'Select Transform' => '',
        'Uppercase'        => 'uppercase',
        'Lowercase'        => 'lowercase',
      ),
      'group'       => 'Custom Font Properties'
    ),

    array(
      'type'        => 'textfield',
      'heading'     => 'Margin Top',
      'param_name'  => 'margin_top',
      'description' => 'Enter the size in pixel e.g 45px',
      'group'       => 'Custom Margin Properties'
    ),

    array(
      'type'        => 'textfield',
      'heading'     => 'Margin Bottom',
      'param_name'  => 'margin_bottom',
      'description' => 'Enter the size in pixel e.g 45px',
      'group'       => 'Custom Margin Properties'
    ),
    // Extras
    $vc_map_extra_id,
    $vc_map_extra_class,

  )
) );


if ( is_plugin_active( 'wp-hotel-booking/wp-hotel-booking.php' ) ) {
  vc_map( array(
    'name'            => 'Featured Rooms',
    'base'            => 'rs_featured_rooms',
    'category'        => 'Hotel Bay Elements',
    'icon'            => 'fa fa-briefcase',
    'description'     => 'Create a featured rooms',
    'params'          => array(
      array(
        'type'        => 'vc_efa_chosen',
        'heading'     => 'Room Type',
        'description' => 'Show service items only from these categories',
        'param_name'  => 'cats',
        'placeholder' => 'Categories',
        'value'       => rs_get_custom_term_values('hb_room_type'),
        'admin_label' => true,
        'std'         => '',
      ),
      array(
        'type'        => 'textfield',
        'heading'     => 'Post Limit',
        'param_name'  => 'limit',
        'admin_label' => true,
      ),
      array(
        'type'        => 'vc_link',
        'heading'     => 'Button Link',
        'param_name'  => 'btn_link',
        'admin_label' => true,
      ),
      // Extras
      $vc_map_extra_class,
    )

  ) );

  vc_map( array(
    'name'            => 'Featured Rooms Carousel',
    'base'            => 'rs_featured_rooms_carousel',
    'category'        => 'Hotel Bay Elements',
    'icon'            => 'fa fa-briefcase',
    'description'     => 'Create a featured rooms slider',
    'params'          => array(
      array(
        'type'        => 'vc_efa_chosen',
        'heading'     => 'Room Type',
        'description' => 'Show service items only from these categories',
        'param_name'  => 'cats',
        'placeholder' => 'Categories',
        'value'       => rs_get_custom_term_values('hb_room_type'),
        'admin_label' => true,
        'std'         => '',
      ),
      array(
        'type'        => 'textfield',
        'heading'     => 'Post Limit',
        'param_name'  => 'limit',
        'admin_label' => true,
      ),
      // Extras
      $vc_map_extra_id,
      $vc_map_extra_class,
    )

  ) );

}

vc_map( array(
  'name'                    => 'Featured Slider',
  'base'                    => 'rs_featured_slider',
  'category'                => 'Hotel Bay Elements',
  'icon'                    => 'fa fa-bank',
  'as_parent'               => array('only' => 'rs_featured_slider_item'),
  'show_settings_on_create' => true,
  'js_view'                 => 'VcColumnView',
  'content_element'         => true,
  'description'             => 'Create a featured slider.',
  'params'  => array(
    array(
      'type'       => 'dropdown',
      'param_name' => 'style',
      'heading'    => 'Style',
      'admin_label' => true,
      'value'       => array(
        'Style 1' => 'style1',
        'Style 2' => 'style2',
      ),
    ),
    array(
      'type'        => 'colorpicker',
      'heading'     => 'Heading Color',
      'param_name'  => 'heading_color',
      'group'       => 'Custom Color Properties'
    ),
    array(
      'type'        => 'colorpicker',
      'heading'     => 'Content Color',
      'param_name'  => 'content_color',
      'group'       => 'Custom Color Properties'
    ),
    $vc_map_extra_id,
    $vc_map_extra_class,
  ),

) );

vc_map( array(
  'name'                    => 'Featured Content Slider Item',
  'base'                    => 'rs_featured_slider_item',
  'category'                => 'Hotel Bay Elements',
  'icon'                    => 'fa fa-bank',
  'description'             => 'Add featured slider item item.',
  'as_child'                => array('only' => 'rs_featured_slider'),
  'params'  => array(
    array(
      'type'        => 'attach_image',
      'heading'     => 'Background',
      'param_name'  => 'background',
      'admin_label' => true,
      'value'       => ''
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Heading',
      'param_name'  => 'heading',
      'holder'      => 'h3',
      'value'       => ''
    ),
    array(
      'type'        => 'textarea',
      'heading'     => 'Content',
      'param_name'  => 'description',
      'holder'      => 'p',
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Button Text',
      'param_name'  => 'btn_text',
      'admin_label' => true,
      'description' => 'This field is only for style1.'
    ),
    array(
      'type'        => 'vc_link',
      'heading'     => 'Link',
      'param_name'  => 'btn_link',
      'admin_label' => true,
    ),
  )

) );

vc_map( array(
  'name'          => 'Icon Box',
  'base'          => 'rs_icon_box',
  'category'      => 'Hotel Bay Elements',
  'icon'          => 'fa fa-dot-circle-o',
  'description'   => 'Create a feature box.',
  'params'        => array(
    array(
      'type'        => 'attach_image',
      'heading'     => 'Icon',
      'param_name'  => 'img_icon',
    ),
    array(
      'type'        => 'attach_image',
      'heading'     => 'Background Image on Hover',
      'param_name'  => 'bg_img_hover',
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Heding',
      'param_name'  => 'heading',
      'holder'      => 'h3'
    ),
    array(
      'type'        => 'textarea_html',
      'heading'     => 'Content',
      'param_name'  => 'content',
      'holder'      => 'div',
    ),
    array(
      'type'        => 'vc_link',
      'heading'     => 'Link',
      'param_name'  => 'icon_box_link',
    ),

    // Extras
    $vc_map_extra_id,
    $vc_map_extra_class,

  )
) );

vc_map( array(
  'name'          => 'Animities',
  'base'          => 'rs_animities',
  'category'      => 'Hotel Bay Elements',
  'icon'          => 'fa fa fa-arrows-v',
  'description'   => 'Add animities.',
  'params'        => array(
    array(
      'type'        => 'textfield',
      'heading'     => 'Heading',
      'param_name'  => 'heading',
      'value'       => 'Animities',
      'holder'      => 'h1',
      'description' => 'Add heading e.g Hotel Animities'
    ),
    array(
      'type'       => 'param_group',
      'heading'    => 'Animity',
      'param_name' => 'animity',
      'value'      => urlencode( json_encode( array(
        array(
          'icon' => 'fa fa-wifi',
          'label' => 'Wifi',
        ),
        array(
          'icon' => 'fa fa-television',
          'label' => 'Television',
        ),
        array(
          'icon' => 'fa fa-newspaper-o',
          'label' => 'Local Newspaper',
        )
      ) ) ),
      'params' => array(
        array(
          'type'       => 'iconpicker',
          'heading'    => 'Icon',
          'param_name' => 'icon',
          'value'      => 'fa fa-wifi',
          'admin_label' => true,
          'settings'   => array(
            'type'         => 'fontawesome',
            'emptyIcon'    => false,
            'iconsPerPage' => 4000,
          ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => 'Label',
          'param_name'  => 'label',
          'admin_label' => true,
        ),
      ),
    ),
    $vc_map_extra_id,
    $vc_map_extra_class,
  )
) );

vc_map( array(
  'name'          => 'Check List',
  'base'          => 'rs_check_list',
  'category'      => 'Hotel Bay Elements',
  'icon'          => 'fa fa fa-arrows-v',
  'description'   => 'Add check list.',
  'params'        => array(
    array(
      'type'       => 'param_group',
      'heading'    => 'List',
      'param_name' => 'list',
      'value'      => urlencode( json_encode( array(
        array(
          'list_item' => 'Air Conditioning',
        ),
        array(
          'list_item' => 'Wifi',
        ),
        array(
          'list_item' => 'Laundry',
        )
      ) ) ),
      'params' => array(
        array(
          'type'        => 'textfield',
          'heading'     => 'List Item',
          'param_name'  => 'list_item',
          'admin_label' => true,
        ),
      ),
    ),
    $vc_map_extra_id,
    $vc_map_extra_class,
  )
) );

vc_map( array(
  'name'          => 'Space',
  'base'          => 'rs_space',
  'category'      => 'Hotel Bay Elements',
  'icon'          => 'fa fa fa-arrows-v',
  'description'   => 'Add space.',
  'params'        => array(
    array(
      'type'        => 'dropdown',
      'heading'     => 'Height',
      'admin_label' => true,
      'param_name'  => 'lg_device',
      'group'       => 'Large Device',
      'value'       => rs_get_space_array(),
      'description' => 'All values are in px'
    ),
    array(
      'type'        => 'dropdown',
      'heading'     => 'Height',
      'admin_label' => true,
      'param_name'  => 'md_device',
      'group'       => 'Medium Device',
      'value'       => rs_get_space_array(),
      'description' => 'All values are in px'
    ),
    array(
      'type'        => 'dropdown',
      'heading'     => 'Height',
      'admin_label' => true,
      'param_name'  => 'sm_device',
      'group'       => 'Small Device',
      'value'       => rs_get_space_array(),
      'description' => 'All values are in px'
    ),
    array(
      'type'        => 'dropdown',
      'heading'     => 'Height',
      'admin_label' => true,
      'param_name'  => 'xs_device',
      'group'       => 'Extra Small Device',
      'value'       => rs_get_space_array(),
      'description' => 'All values are in px'
    ),

    $vc_map_extra_id,
    $vc_map_extra_class,
  )
) );

vc_map( array(
  'name'          => 'Text Block With Signature',
  'base'          => 'rs_text_block_with_signature',
  'category'      => 'Hotel Bay Elements',
  'icon'          => 'fa fa fa-arrows-v',
  'description'   => 'Add text block with signature.',
  'params'        => array(
    array(
      'type'        => 'textarea',
      'heading'     => 'Small Heading',
      'param_name'  => 'small_heading',
      'holder'      => 'h5',
    ),
    array(
      'type'        => 'textarea',
      'heading'     => 'Big Heading',
      'param_name'  => 'big_heading',
      'holder'      => 'h2',
    ),
    array(
      'type'        => 'textarea_html',
      'heading'     => 'Content',
      'param_name'  => 'content',
      'holder'      => 'div',
    ),
    array(
      'type'        => 'attach_image',
      'heading'     => 'Signature',
      'param_name'  => 'signature',
    ),
    $vc_map_extra_id,
    $vc_map_extra_class,
  )
) );

vc_map( array(
  'name'          => 'Section Heading',
  'base'          => 'rs_section_heading',
  'category'      => 'Hotel Bay Elements',
  'icon'          => 'fa fa-text-width',
  'description'   => 'Add section heading.',
  'params'        => array(
    array(
      'type'        => 'textfield',
      'heading'     => 'Small Heading',
      'holder'      => 'h4',
      'param_name'  => 'small_heading',
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Big Heading',
      'holder'      => 'h1',
      'param_name'  => 'big_heading',
    ),
    array(
      'type'        => 'colorpicker',
      'heading'     => 'Color',
      'param_name'  => 'small_heading_color',
      'admin_label' => true,
      'group'       => 'Small Heading Properties'
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Font Size',
      'admin_label' => true,
      'param_name'  => 'small_heading_font_size',
      'group'       => 'Small Heading Properties'
    ),

    array(
      'type'        => 'colorpicker',
      'heading'     => 'Color',
      'param_name'  => 'big_heading_color',
      'admin_label' => true,
      'group'       => 'Big Heading Properties'
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Font Size',
      'admin_label' => true,
      'param_name'  => 'big_heading_font_size',
      'group'       => 'Big Heading Properties'
    ),
    $vc_map_extra_id,
    $vc_map_extra_class,
  )
) );

if ( is_plugin_active( 'wp-instagram-widget/wp-instagram-widget.php' ) ) {
  vc_map( array(
    'name'          => 'Instagram',
    'base'          => 'rs_instagram',
    'category'      => 'Hotel Bay Elements',
    'icon'          => 'fa fa-text-width',
    'description'   => 'Add instagram images.',
    'params'        => array(
      array(
        'type'        => 'textfield',
        'heading'     => '@username or #tag',
        'admin_label' => true,
        'param_name'  => 'username',
      ),
      array(
        'type'        => 'textfield',
        'heading'     => 'Limit',
        'admin_label' => true,
        'param_name'  => 'limit',
      ),
    )
  ) );
}

vc_map( array(
  'name'            => 'FAQ',
  'base'            => 'vc_accordion',
  'category'        => 'Hotel Bay Elements',
  'is_container'    => true,
  'icon'            => 'fa fa-plus-circle',
  'description'     => 'Accordion',
  'params'          => array(
    array(
      'type'        => 'textfield',
      'heading'     => 'Active tab',
      'param_name'  => 'active',
    ),
    $vc_map_extra_id,
    $vc_map_extra_class,
  ),

  'custom_markup'   => '<div class="wpb_accordion_holder wpb_holder clearfix vc_container_for_children">%content%</div><div class="tab_controls"><a class="add_tab" title="Add section"><span class="vc_icon"></span> <span class="tab-label">Add section</span></a></div>',
  'default_content' => '
    [vc_accordion_tab title="Section 1"][/vc_accordion_tab]
    [vc_accordion_tab title="Section 2"][/vc_accordion_tab]
  ',
  'js_view'         => 'VcAccordionView'
) );

vc_map( array(
  'name'                      => 'FAQ Section',
  'base'                      => 'vc_accordion_tab',
  'allowed_container_element' => 'vc_row',
  'is_container'              => true,
  'content_element'           => false,
  'params'                    => array(
    array(
      'type'        => 'textfield',
      'heading'     => 'Title',
      'param_name'  => 'title',
    ),
  ),
  'js_view'         => 'VcAccordionTabView'
) );

vc_map( array(
  'name'          => 'Text Block',
  'base'          => 'vc_column_text',
  'category'      => 'Hotel Bay Elements',
  'icon'          => 'fa fa-text-width',
  'description'   => 'A block of text with WYSIWYG editor',
  'params'        => array(
    array(
      'holder'     => 'div',
      'type'       => 'textarea_html',
      'heading'    => 'Text',
      'param_name' => 'content',
      'value'      => '<p>I am text block. Click edit button to change this text.</p>',
    ),
    $vc_map_extra_id,
    $vc_map_extra_class,
  )
) );

vc_map( array(
  'name'        => 'Hero Video Banner',
  'base'        => 'rs_hero_video_banner',
  'category'    => 'Hotel Bay Elements',
  'icon'        => 'fa fa fa-arrows-v',
  'description' => 'Add hero video banner.',
  'params'        => array(
    array(
      'type'       => 'dropdown',
      'param_name' => 'style',
      'heading'    => 'Style',
      'admin_label' => true,
      'value'       => array(
        'Style 1' => 'style1',
        'Style 2' => 'style2',
        'Style 3' => 'style3',
        'Style 4' => 'style4',
        'Style 5' => 'style5',
        'Style 6' => 'style6',
        'Style 7' => 'style7',
      ),
    ),
    array(
      'type'       => 'dropdown',
      'param_name' => 'height',
      'heading'    => 'Height',
      'admin_label' => true,
      'value'       => array(
        'Small' => 'small',
        'Big'   => 'big',
      ),
    ),
    array(
      'type'        => 'attach_image',
      'heading'     => 'Poster',
      'admin_label' => true,
      'param_name'  => 'poster_img',
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Youtube URL',
      'admin_label' => true,
      'param_name'  => 'video_url',
      'description' => 'for e.g. http://youtu.be/I6jmZ5plZ3o',
    ),
    array(
      'type'        => 'textarea',
      'heading'     => 'Small Heading',
      'param_name'  => 'small_heading',
      'holder'      => 'h4',
      'value'       => ''
    ),
    array(
      'type'        => 'textarea',
      'heading'     => 'Heading',
      'param_name'  => 'big_heading',
      'holder'      => 'h1',
      'value'       => ''
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Button Text',
      'param_name'  => 'btn_text',
      'value'       => '',
    ),
    array(
      'type'         => 'vc_link',
      'heading'      => 'Button Link',
      'param_name'   => 'btn_link',
      'value'        => '',
    ),
    array(
      'type'        => 'colorpicker',
      'heading'     => 'Big Heading Color',
      'param_name'  => 'big_heading_color',
      'group'       => 'Custom Colors'
    ),
    array(
      'type'        => 'colorpicker',
      'heading'     => 'Small Heading Color',
      'param_name'  => 'small_heading_color',
      'group'       => 'Custom Colors'
    ),
    array(
      'type'        => 'colorpicker',
      'heading'     => 'Button Text color',
      'param_name'  => 'btn_text_color',
      'group'       => 'Custom Colors'
    ),
    $vc_map_extra_id,
    $vc_map_extra_class,
  )
) );

vc_map( array(
  'name'                    => 'Hero Slider',
  'base'                    => 'rs_hero_slider',
  'category'                => 'Hotel Bay Elements',
  'icon'                    => 'fa fa-bank',
  'as_parent'               => array('only' => 'rs_hero_slider_item'),
  'show_settings_on_create' => true,
  'js_view'                 => 'VcColumnView',
  'content_element'         => true,
  'description'             => 'Create a hero slider.',
  'params'  => array(
    array(
      'type'       => 'dropdown',
      'param_name' => 'style',
      'heading'    => 'Style',
      'value'       => array(
        'Style 1' => 'style1',
        'Style 2' => 'style2',
        'Style 3' => 'style3',
        'Style 4' => 'style4',
        'Style 5' => 'style5',
        'Style 6' => 'style6',
        'Style 7' => 'style7',
      ),
    ),
    array(
      'type'       => 'dropdown',
      'param_name' => 'height',
      'heading'    => 'Height',
      'value'       => array(
        'Small' => 'small',
        'Big'   => 'big',
      ),
    ),
    array(
      'type'        => 'colorpicker',
      'heading'     => 'Big Heading Color',
      'param_name'  => 'big_heading_color',
      'group'       => 'Custom Colors'
    ),
    array(
      'type'        => 'colorpicker',
      'heading'     => 'Small Heading Color',
      'param_name'  => 'small_heading_color',
      'group'       => 'Custom Colors'
    ),
    array(
      'type'        => 'dropdown',
      'heading'     => 'Loop',
      'param_name'  => 'loop',
      'value'       => array(
        'No'  => 'false',
        'Yes' => 'true',
      ),
    ),
    array(
      'type'        => 'dropdown',
      'heading'     => 'Autoplay',
      'param_name'  => 'autoplay',
      'value'       => array(
        'No'  => 'false',
        'Yes' => 'true',
      ),
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Autoplay Speed',
      'param_name'  => 'speed',
      'value'       => '',
      'description' => 'Default is 5000'
    ),
    $vc_map_extra_id,
    $vc_map_extra_class,
  ),

) );

vc_map( array(
  'name'                    => 'Hero Slider Item',
  'base'                    => 'rs_hero_slider_item',
  'icon'                    => 'fa fa-bank',
  'description'             => 'Add promo item.',
  'as_child'                => array('only' => 'rs_hero_slider'),
  'params'  => array(
    array(
      'type'        => 'attach_image',
      'heading'     => 'Background',
      'param_name'  => 'background',
      'admin_label' => true,
      'value'       => ''
    ),
    array(
      'type'        => 'dropdown',
      'heading'     => 'Overlay',
      'param_name'  => 'overlay',
      'value'       => array(
        'No'  => 'no',
        'Yes' => 'yes',
      ),
    ),
    array(
      'type'        => 'textarea',
      'heading'     => 'Small Heading',
      'param_name'  => 'small_heading',
      'holder'      => 'h3',
      'value'       => ''
    ),
    array(
      'type'        => 'textarea',
      'heading'     => 'Big Heading',
      'param_name'  => 'heading',
      'holder'      => 'h1',
      'value'       => ''
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Button Text',
      'param_name'  => 'btn_text',
      'value'       => '',
    ),
    array(
      'type'         => 'vc_link',
      'heading'      => 'Button Link',
      'param_name'   => 'btn_link',
      'value'        => '',
    ),
  )

) );

vc_map( array(
  'name'          => 'Google Map',
  'base'          => 'rs_google_map',
  'icon'          => 'fa fa-map-marker',
  'category'      => 'Hotel Bay Elements',
  'description'   => 'Add google map.',
  'params'        => array(
    array(
      'type'       => 'dropdown',
      'param_name' => 'usage',
      'heading'    => 'Usage',
      'admin_label' => true,
      'value'       => array(
        'With Latitude and Longitude' => 'with_lat_long',
        'iFrame'                      => 'iframe',
      ),
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Latitude',
      'param_name'  => 'latitude',
      'admin_label' => true,
      'dependency'  => array( 'element' => 'usage', 'value' => array('with_lat_long') ),
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Longitude',
      'param_name'  => 'longitude',
      'admin_label' => true,
      'dependency'  => array( 'element' => 'usage', 'value' => array('with_lat_long') ),
    ),
    array(
      'type'        => 'attach_image',
      'heading'     => 'Marker',
      'param_name'  => 'marker',
      'admin_label' => true,
      'dependency'  => array( 'element' => 'usage', 'value' => array('with_lat_long') ),
    ),
    array(
      'type'        => 'textarea_raw_html',
      'heading'     => 'iFrame Code',
      'param_name'  => 'iframe_code',
      'description' => 'Visit <a href="https://www.google.com/maps">Google maps</a> to create your map (Step by step: 1) Find location 2) Click the cog symbol in the lower right corner and select "Share or embed map" 3) On modal window select "Embed map" 4) Copy iframe code and paste it). and for google map street view follow this tutorial <a href="https://www.youtube.com/watch?v=wZUt2Ned_ds">https://www.youtube.com/watch?v=wZUt2Ned_ds</a>',
      'dependency'  => array( 'element' => 'usage', 'value' => array('iframe') ),
    ),
    // Extras
    $vc_map_extra_id,
    $vc_map_extra_class,

  )
) );

vc_map( array(
  'name'          => 'Counter',
  'base'          => 'rs_counter',
  'category'      => 'Hotel Bay Elements',
  'icon'          => 'fa fa-shopping-cart',
  'description'   => 'Add counter.',
  'params'        => array(
    array(
      'type'       => 'iconpicker',
      'heading'    => 'Icon',
      'param_name' => 'icon',
      'value'      => 'ti-Line-3d-glasses',
      'settings' => array(
        'type'         => 'tonicon',
        'emptyIcon'    => false,
        'iconsPerPage' => 4000,
      ),
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Count Number',
      'param_name'  => 'count_no',
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Title',
      'param_name'  => 'title',
      'holder'      => 'h4'
    ),
     // Extras
    $vc_map_extra_id,
    $vc_map_extra_class,

  )
) );

vc_map( array(
  'name'          => 'Count Down Timer',
  'base'          => 'rs_countdown_timer',
  'category'      => 'Hotel Bay Elements',
  'icon'          => 'fa fa-shopping-cart',
  'description'   => 'Add count down timer.',
  'params'        => array(
    array(
      'type'        => 'attach_image',
      'heading'     => 'Background Image',
      'admin_label' => true,
      'param_name'  => 'bg_image',
    ),
    array(
      'type'        => 'dropdown',
      'heading'     => 'Overlay',
      'param_name'  => 'overlay',
      'value'       => array(
        'No'  => 'no',
        'Yes' => 'yes',
      ),
    ),
    array(
      'type'        => 'textarea',
      'heading'     => 'Small Heading',
      'param_name'  => 'small_heading',
      'holder'      => 'h5'
    ),
    array(
      'type'        => 'textarea',
      'heading'     => 'Big Heading',
      'param_name'  => 'big_heading',
      'holder'      => 'h1'
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Year',
      'admin_label' => true,
      'param_name'  => 'year',
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Month',
      'admin_label' => true,
      'param_name'  => 'month',
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Day',
      'admin_label' => true,
      'param_name'  => 'day',
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Button Text',
      'param_name'  => 'btn_text',
      'admin_label' => true,
    ),
    array(
      'type'        => 'vc_link',
      'heading'     => 'Button Link',
      'param_name'  => 'btn_link',
      'admin_label' => true,
    ),
     // Extras
    $vc_map_extra_id,
    $vc_map_extra_class,

  )
) );

vc_map( array(
  'name'          => 'Video Banner',
  'base'          => 'rs_video_banner',
  'category'      => 'Hotel Bay Elements',
  'icon'          => 'fa fa fa-arrows-v',
  'description'   => 'Add hero video banner.',
  'params'        => array(
    array(
      'type'        => 'attach_image',
      'heading'     => 'Background Image',
      'admin_label' => true,
      'param_name'  => 'bg_image',
    ),
    array(
      'type'        => 'dropdown',
      'heading'     => 'Overlay',
      'param_name'  => 'overlay',
      'value'       => array(
        'No'  => 'no',
        'Yes' => 'yes',
      ),
    ),
    array(
      'type'        => 'textfield',
      'heading'     => 'Youtube URL',
      'admin_label' => true,
      'param_name'  => 'video_url',
      'description' => 'for e.g. https://www.youtube.com/embed/6VTQrJ5_Qho',
    ),
    array(
      'type'        => 'textarea',
      'heading'     => 'Small Heading',
      'param_name'  => 'small_heading',
      'holder'      => 'h4',
      'value'       => ''
    ),
    array(
      'type'        => 'textarea',
      'heading'     => 'Heading',
      'param_name'  => 'big_heading',
      'holder'      => 'h1',
      'value'       => ''
    ),
    array(
      'type'        => 'colorpicker',
      'heading'     => 'Big Heading Color',
      'param_name'  => 'big_heading_color',
      'group'       => 'Custom Colors'
    ),
    array(
      'type'        => 'colorpicker',
      'heading'     => 'Small Heading Color',
      'param_name'  => 'small_heading_color',
      'group'       => 'Custom Colors'
    ),
    $vc_map_extra_id,
    $vc_map_extra_class,
  )
) );

vc_map( array(
  'name'                    => 'Tabs',
  'base'                    => 'vc_tta_tabs',
  'category'                => 'Hotel Bay Elements',
  'icon'                    => 'fa fa-toggle-right',
  'is_container'            => true,
  'show_settings_on_create' => false,
  'as_parent'               => array('only' => 'vc_tta_section',),
  'description'             => 'Tabbed content',
  'params' => array(
    array(
      'type'       => 'textfield',
      'param_name' => 'active',
      'heading'    => 'Active',
    ),
    array(
      'type'       => 'dropdown',
      'param_name' => 'style',
      'heading'    => 'Style',
      'value'       => array(
        'Style 1' => 'style-1',
        'Style 2' => 'style-2',
      ),
    ),
    $vc_map_extra_id,
    $vc_map_extra_class,
  ),
  'js_view' => 'VcBackendTtaTabsView',
  'custom_markup' => '
    <div class="vc_tta-container" data-vc-action="collapse">
      <div class="vc_general vc_tta vc_tta-tabs vc_tta-color-backend-tabs-white vc_tta-style-flat vc_tta-shape-rounded vc_tta-spacing-1 vc_tta-tabs-position-top vc_tta-controls-align-left">
        <div class="vc_tta-tabs-container">'
                         . '<ul class="vc_tta-tabs-list">'
                         . '<li class="vc_tta-tab" data-vc-tab data-vc-target-model-id="{{ model_id }}" data-element_type="vc_tta_section"><a href="javascript:;" data-vc-tabs data-vc-container=".vc_tta" data-vc-target="[data-model-id=\'{{ model_id }}\']" data-vc-target-model-id="{{ model_id }}"><span class="vc_tta-title-text">{{ section_title }}</span></a></li>'
                         . '</ul>
        </div>
        <div class="vc_tta-panels vc_clearfix {{container-class}}">
          {{ content }}
        </div>
      </div>
    </div>',
  'default_content' => '
  [vc_tta_section title="' . sprintf( '%s %d', __( 'Tab', 'marketing-addons' ), 1 ) . '"][/vc_tta_section]
  [vc_tta_section title="' . sprintf( '%s %d', __( 'Tab', 'marketing-addons' ), 2 ) . '"][/vc_tta_section]
  ',
  'admin_enqueue_js' => array(
    vc_asset_url( 'lib/vc_tabs/vc-tabs.min.js' ),
  ),
) );

vc_map( array(
  'name'                      => 'Tab',
  'base'                      => 'vc_tta_section',
  'icon'                      => '',
  'allowed_container_element' => 'vc_row',
  'is_container'              => true,
  'show_settings_on_create'   => false,
  'as_child'                  => array('only' => 'vc_tta_tabs'),
  'params' => array(
    array(
      'type'        => 'textfield',
      'param_name'  => 'title',
      'heading'     => 'Title',
    ),
  ),
  'js_view' => 'VcBackendTtaSectionView',
  'custom_markup' => '
    <div class="vc_tta-panel-heading">
        <h4 class="vc_tta-panel-title vc_tta-controls-icon-position-left"><a href="javascript:;" data-vc-target="[data-model-id=\'{{ model_id }}\']" data-vc-accordion data-vc-container=".vc_tta-container"><span class="vc_tta-title-text">{{ section_title }}</span><i class="vc_tta-controls-icon vc_tta-controls-icon-plus"></i></a></h4>
    </div>
    <div class="vc_tta-panel-body">
      {{ editor_controls }}
      <div class="{{ container-class }}">
      {{ content }}
      </div>
    </div>',
  'default_content' => '',
) );

vc_map( array(
  'name'            => 'Accordion',
  'base'            => 'vc_accordion',
  'category'        => 'Hotel Bay Elements',
  'is_container'    => true,
  'icon'            => 'fa fa-plus-circle',
  'description'     => 'Accordion',
  'params'          => array(
    array(
      'type'        => 'textfield',
      'heading'     => 'Active tab',
      'param_name'  => 'active',
    ),
    $vc_map_extra_id,
    $vc_map_extra_class,
  ),

  'custom_markup'   => '<div class="wpb_accordion_holder wpb_holder clearfix vc_container_for_children">%content%</div><div class="tab_controls"><a class="add_tab" title="Add section"><span class="vc_icon"></span> <span class="tab-label">Add section</span></a></div>',
  'default_content' => '
    [vc_accordion_tab title="Section 1"][/vc_accordion_tab]
    [vc_accordion_tab title="Section 2"][/vc_accordion_tab]
  ',
  'js_view'         => 'VcAccordionView'
) );

vc_map( array(
  'name'                      => 'Accordion Section',
  'base'                      => 'vc_accordion_tab',
  'allowed_container_element' => 'vc_row',
  'is_container'              => true,
  'content_element'           => false,
  'params'                    => array(
    array(
      'type'        => 'textfield',
      'heading'     => 'Title',
      'param_name'  => 'title',
    ),
  ),
  'js_view'         => 'VcAccordionTabView'
) );


require_once vc_path_dir( 'SHORTCODES_DIR', 'vc-tab.php' );
require_once vc_path_dir( 'SHORTCODES_DIR', 'vc-tabs.php' );
class WPBakeryShortCode_RS_Hero_Slider   extends WPBakeryShortCodesContainer {}
class WPBakeryShortCode_RS_Hero_Slider_Item  extends WPBakeryShortCode {}
class WPBakeryShortCode_RS_Featured_Slider   extends WPBakeryShortCodesContainer {}
class WPBakeryShortCode_RS_Featured_Slider_Item  extends WPBakeryShortCode {}

class RS_WPBakeryShortCodesContainer extends WPBakeryShortCodesContainer {
  public function contentAdmin( $atts, $content = null ) {
      $width = $el_class = '';
      extract( shortcode_atts( $this->predefined_atts, $atts ) );
      $label_class = ( isset( $this->settings['label_class'] ) ) ? $this->settings['label_class'] : 'info';
      $output  = '';

      $column_controls = $this->getColumnControls( $this->settings( 'controls' ) );
      $column_controls_bottom = $this->getColumnControls( 'add', 'bottom-controls' );
      for ( $i = 0; $i < count( $width ); $i ++ ) {
        $output .= '<div ' . $this->mainHtmlBlockParams( $width, $i ) . '>';
        $output .= '<div class="rs-container-title"><span class="rs-label rs-label-'. $label_class .'">'. $this->settings['name'] .'</span></div>'; // ADDED THIS LINE
        $output .= $column_controls;
        $output .= '<div class="wpb_element_wrapper">';
        $output .= '<div ' . $this->containerHtmlBlockParams( $width, $i ) . '>';
        $output .= do_shortcode( shortcode_unautop( $content ) );
        $output .= '</div>';
        if ( isset( $this->settings['params'] ) ) {
          $inner = '';
          foreach ( $this->settings['params'] as $param ) {
            $param_value = isset( $$param['param_name'] ) ? $$param['param_name'] : '';
            if ( is_array( $param_value ) ) {
              // Get first element from the array
              reset( $param_value );
              $first_key = key( $param_value );
              $param_value = $param_value[$first_key];
            }
            $inner .= $this->singleParamHtmlHolder( $param, $param_value );
          }
          $output .= $inner;
        }
        $output .= '</div>';
        $output .= $column_controls_bottom;
        $output .= '</div>';
      }
      return $output;
  }
}

