<?php
/**
 * Customer Service
 *
 * @package hotelbay-addons
 */

class hotelbay_WP_Customer_Service_Widget extends WP_Widget {
  function __construct() {
    $widget_ops = array('classname' => 'widget_customer_service', 'description' => esc_html__( 'Diplay Customer Service Details', 'hotelbay-addons' ) );
    parent::__construct('customer-service', esc_html__( '- luxe: Customer Service', 'hotelbay-addons' ), $widget_ops);

    $this->alt_option_name = 'widget_customer_service';

    add_action( 'save_post',    array(&$this, 'flush_widget_cache') );
    add_action( 'deleted_post', array(&$this, 'flush_widget_cache') );
    add_action( 'switch_theme', array(&$this, 'flush_widget_cache') );
  }

  function widget($args, $instance) {
    global $post;
    $cache = wp_cache_get('widget_customer_service', 'widget');

    if ( !is_array($cache) ) {
      $cache = array();
    }

    if ( ! isset( $args['widget_id'] ) ) {
      $args['widget_id'] = $this->id;
    }

    if ( isset( $cache[ $args['widget_id'] ] ) ) {
      echo $cache[ $args['widget_id'] ];
      return;
    }

    ob_start();
    extract($args);
    echo $before_widget;

    $title = apply_filters('widget_title', $instance['title'], $instance, $this->id_base);

    if ($title):
      echo $before_title.esc_html($title).$after_title;
    endif; ?>
      <div class="contact-info">
        <i class="contact-info__icon fa fa-phone"></i>
        <div class="contact-info__wrap">
          <?php if(isset($instance['info'])): ?>
            <div class="contact-info__subtitle"><?php echo esc_html($instance['info']); ?></div>
          <?php endif; ?>
          <?php if(isset($instance['phone_no'])): ?>
            <div class="contact-info__title"><?php echo esc_html($instance['phone_no']); ?></div>
          <?php endif; ?>
        </div>
      </div>
    <?php echo $after_widget;
    $cache[$args['widget_id']] = ob_get_flush();
    wp_cache_set('widget_customer_service', $cache, 'widget');
  }

  function update( $new_instance, $old_instance ) {
    $instance             = $old_instance;
    $instance['title']    = strip_tags($new_instance['title']);
    $instance['phone_no'] = strip_tags($new_instance['phone_no']);
    $instance['info']     = wp_kses_post($new_instance['info']);

    $this->flush_widget_cache();

    $alloptions = wp_cache_get( 'alloptions', 'options' );
    if ( isset($alloptions['widget_customer_service']) ) {
      delete_option('widget_customer_service');
    }
    return $instance;
  }

  function flush_widget_cache() {
    wp_cache_delete('widget_customer_service', 'widget');
  }

  function form( $instance ) {
    $title    = isset($instance['title']) ? $instance['title'] : '';
    $phone_no = isset($instance['phone_no']) ? $instance['phone_no'] : '';
    $info     = isset($instance['info']) ? $instance['info'] : '';

    ?>
    <p><label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e( 'Title:', 'hotelbay-addons' ); ?></label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>

    <p><label for="<?php echo esc_attr($this->get_field_id('info')); ?>"><?php esc_html_e( 'Info', 'hotelbay-addons' ); ?></label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id('info')); ?>" name="<?php echo esc_attr($this->get_field_name('info')); ?>" type="text" value="<?php echo esc_attr($info); ?>" /></p>

    <p><label for="<?php echo esc_attr($this->get_field_id('phone_no')); ?>"><?php esc_html_e( 'Phone Number', 'hotelbay-addons' ); ?></label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id('phone_no')); ?>" name="<?php echo esc_attr($this->get_field_name('phone_no')); ?>" type="text" value="<?php echo esc_attr($phone_no); ?>" /></p>

    <?php
  }
}
