<?php
/**
 *
 * RS Tabs
 * @since 1.0.0
 * @version 1.0.0
 *
 */
function rs_tabs( $atts, $content = '', $id = '' ) {

  global $rs_tabs;
  $rs_tabs = array();

  extract( shortcode_atts( array(
    'id'     => '',
    'class'  => '',
    'style'  => 'style-1',
    'active' => 1,
  ), $atts ) );

  do_shortcode( $content );

  if( empty( $rs_tabs ) ) { return; }

  $output = '';
  $id     = ( $id ) ? ' id="'. esc_attr($id) .'"' : '';
  $class  = ( $class ) ? ' '. luxe_sanitize_html_classes($class) : '';

  $output .=  '<div '.$id.' class="tab mb-0 tab--'.$style.''.$class.'">';
  $output .=  '<ul class="tab-nav" role="tablist">';
  foreach( $rs_tabs as $key => $tab) {
    $title_id = strtolower(str_replace(' ', '-', $tab['atts']['title']));
    $unique_id = 'tab-'.$title_id.$key;
    $active_nav = ( ( $key + 1 ) == $active ) ? ' active ' : '';
    $title      = esc_html($tab['atts']['title']);
    $output .= '<li role="presentation" class="tab-nav__item'.$active_nav.'">
               <a class="tab-nav__link" href="#'.$unique_id.'" aria-controls="'.$unique_id.'" role="tab" data-toggle="tab">'.esc_html($title).'</a></li>';
  }
  $output .=  '</ul>';

  $output .=  '<div class="tab__content">';
  foreach( $rs_tabs as $key => $tab) {
    $active_nav = ( ( $key + 1 ) == $active ) ? ' active ' : '';
    $title_id = strtolower(str_replace(' ', '-', $tab['atts']['title']));
    $unique_id = 'tab-'.$title_id.$key;
    $output .=  '<div role="tabpanel" class="tab__pane '.$active_nav.'" id="'.$unique_id.'">';
    $output .=  do_shortcode(wp_kses_post($tab['content']));
    $output .=  '</div>';
  }

  $output .=  '</div>';
  $output .=  '</div>';

  return $output;

}
add_shortcode('vc_tta_tabs', 'rs_tabs');

/**
 *
 * RS Tab
 * @version 1.0.0
 * @since 1.0.0
 *
 */
function rs_tab( $atts, $content = '', $id = '' ) {
  global $rs_tabs;
  $rs_tabs[]  = array( 'atts' => $atts, 'content' => $content );
  return;
}
add_shortcode('vc_tta_section', 'rs_tab');
