<?php
/**
 *
 * RS Featured Slider
 * @since 1.0.0
 * @version 1.0.0
 *
 *
 */
function rs_featured_slider( $atts, $content = '', $id = '' ) {
  global $rs_featured_slider;
  $rs_featured_slider = array();

  extract( shortcode_atts( array(
    'id'            => '',
    'class'         => '',
    'style'         => 'style1',
    'heading_color' => '',
    'content_color' => '',
  ), $atts ) );

  do_shortcode( $content );

  if( empty( $rs_featured_slider ) ) { return; }

  $output        = '';
  $id            = ( $id ) ? ' id="'. esc_attr($id) .'"' : '';
  $class         = ( $class ) ? ' '. luxe_sanitize_html_classes($class) : '';
  $heading_color = ($heading_color) ? ' style="color:'.esc_attr($heading_color).';"':'';
  $content_color = ($content_color) ? ' style="color:'.esc_attr($content_color).';"':'';


  switch ($style) {
    default:
    case 'style1':
      $output .= '<div '.$id.' class="featured-rooms-slider'.$class.'">';

      foreach ($rs_featured_slider as $key => $slide) {
        $image_id    = (isset($slide['atts']['background'])) ? $slide['atts']['background']:'';
        $heading     = (isset($slide['atts']['heading'])) ? $slide['atts']['heading']:'';
        $description = (isset($slide['atts']['description'])) ? $slide['atts']['description']:'';
        $btn_text    = (isset($slide['atts']['btn_text'])) ? $slide['atts']['btn_text']:'Book now';
        $btn_link    = (isset($slide['atts']['btn_link'])) ? $slide['atts']['btn_link']:'';
        $image_url   = rs_get_image_src($image_id);

        if (function_exists('vc_parse_multi_attribute')) {
          $parse_args = vc_parse_multi_attribute($btn_link);
          $href       = ( isset($parse_args['url']) ) ? $parse_args['url'] : '#';
          $title      = ( isset($parse_args['title']) ) ? $parse_args['title'] : 'button';
          $target     = ( isset($parse_args['target']) ) ? trim($parse_args['target']) : '_self';
        }

      
        $output .= '<div class="featured-rooms-slider__item" style="background-image: url('.esc_url($image_url).');">';
        $output .= '<div class="container">';
        $output .= '<div class="featured-rooms-slider__content">';
        $output .= '<div class="featured-rooms-slider__title"'.$heading_color.'>'.wp_kses_post($heading).'</div>';
        $output .= '<div class="featured-rooms-slider__text"'.$content_color.'>'.rs_set_wpautop(wp_kses_post($description)).'</div>';
        $output .= '<a class="btn btn--md btn--normal" href="'.esc_url($href).'" title="'.esc_attr($title).'" target="'.esc_attr($target).'">'.esc_html($btn_text).'</a>';
        $output .= '<div class="slick-nav">';
        $output .= '<button type="button" class="slick-nav__prev">';
        $output .= '<i class="fa fa-angle-left"></i>';
        $output .= '</button>';
        $output .= '<button type="button" class="slick-nav__next">';
        $output .= '<i class="fa fa-angle-right"></i>';
        $output .= '</button>';
        $output .= '</div>';
        $output .= '</div>';
        $output .= '</div>';
        $output .= '</div>';
      }

      $output .= '</div>';
      # code...
      break;
    
    case 'style2':
      $output .=  '<div '.$id.' class="hb-slick__center hb-slider'.$class.'">';
      foreach ($rs_featured_slider as $key => $slide) {
        $image_id    = (isset($slide['atts']['background'])) ? $slide['atts']['background']:'';
        $heading     = (isset($slide['atts']['heading'])) ? $slide['atts']['heading']:'';
        $description = (isset($slide['atts']['description'])) ? $slide['atts']['description']:'';
        $btn_link    = (isset($slide['atts']['btn_link'])) ? $slide['atts']['btn_link']:'';
        $image_url   = rs_get_image_src($image_id);

        if (function_exists('vc_parse_multi_attribute')) {
          $parse_args = vc_parse_multi_attribute($btn_link);
          $href       = ( isset($parse_args['url']) ) ? $parse_args['url'] : '#';
          $title      = ( isset($parse_args['title']) ) ? $parse_args['title'] : 'button';
          $target     = ( isset($parse_args['target']) ) ? trim($parse_args['target']) : '_self';
        }
        $output .=  '<a class="hb-single__slide" href="'.esc_url($href).'" title="'.esc_attr($title).'" target="'.esc_attr($target).'" style="background-image: url('.esc_url($image_url).');">';
        $output .=  '<div class="hb-slider__text">';
        $output .=  '<h2'.$heading_color.'>'.wp_kses_post($heading).'</h2>';
        $output .=  '<span'.$content_color.'>'.rs_set_wpautop(wp_kses_post($description)).'</span>';
        $output .=  '</div>';
        $output .=  '</a>';
      }
      $output .=  '</div>';
      $output .=  '<div class="slick-nav1"></div>';
      break;
  }

  return $output;

}
add_shortcode('rs_featured_slider', 'rs_featured_slider');

/**
 *
 * RS Hero Slider
 * @version 1.0.0
 * @since 1.0.0
 *
 */
function rs_featured_slider_item( $atts, $content = '', $id = '' ) {
  global $rs_featured_slider;
  $rs_featured_slider[]  = array( 'atts' => $atts, 'content' => $content );
  return;
}
add_shortcode('rs_featured_slider_item', 'rs_featured_slider_item');
