<?php

/**
 *
 * Featured Rooms
 * @since 1.0.0
 * @version 1.0.0
 *
 */
function rs_featured_rooms($atts, $content = '', $id = '') {
  global $post;
  extract(shortcode_atts(array(
    'id'       => '',
    'class'    => '',
    'limit'    => 4,
    'btn_link' => '',
    'cats'     => '',
  ), $atts));

  $class       = ( $class ) ? ' ' .$class : '';
  $class_array = array('lg|luxe-medium-alt','md|luxe-medium-hor','sm|luxe-small','sm|luxe-small');

  if (function_exists('vc_parse_multi_attribute')) {
    $parse_args = vc_parse_multi_attribute($btn_link);
    $href       = ( isset($parse_args['url']) ) ? $parse_args['url'] : '#';
    $title      = ( isset($parse_args['title']) ) ? $parse_args['title'] : 'button';
    $target     = ( isset($parse_args['target']) ) ? trim($parse_args['target']) : '_self';
  }

  $args = array(
    'posts_per_page' => $limit,
    'post_type'      => 'hb_room',
  );

  $args['tax_query'] = array(
    array(
      'taxonomy' => 'hb_room_type',
      'field'    => 'slug',
      'terms'    => explode(',', $cats),
    ),
  );
  ob_start();

  $the_query = new WP_Query($args); ?>

  <div <?php echo esc_attr($id); ?> class="featured-rooms <?php echo esc_attr($class); ?>">
    <?php 
      $i = 0;
      while( $the_query->have_posts() ) : $the_query->the_post(); 
      $i = ($i > 4) ? 0:$i;
      $split_array = explode('|', $class_array[$i]);
      $image_src   = rs_get_image_src(get_post_thumbnail_id(get_the_ID()), $split_array[1]);
    ?>
      <a href="<?php echo get_the_permalink(); ?>" class="featured-room featured-room--<?php echo esc_attr($split_array[0]); ?>">
        <div class="featured-room__content">
          <div class="featured-room__title"><?php the_title(); ?></div>
          <div class="featured-room__more"><?php echo luxe_translate('check-detail', 'Check details'); ?></div>
        </div>
        <img class="featured-room__image" src="<?php echo esc_url($image_src); ?>" alt="">
      </a>
    <?php $i++; endwhile; wp_reset_postdata(); ?>
    <a href="<?php echo esc_url($href); ?>" title="<?php echo esc_attr($title); ?>" target="<?php echo esc_attr($target); ?>" class="featured-rooms__link"><?php echo luxe_translate('view-all-rooms', 'View all rooms'); ?></a>
  </div>
  <?php
  $output = ob_get_clean();
  return $output;
}

add_shortcode('rs_featured_rooms', 'rs_featured_rooms');
