<?php
/**
 *
 * Chart
 * @since 1.0.0
 * @version 1.0.0
 *
 */
function rs_counter( $atts, $content = '', $id = '' ) {

  extract( shortcode_atts( array(
    'id'       => '',
    'class'    => '',
    'title'    => '',
    'icon'     => 'ti-Line-3d-glasses',
    'count_no' => '',
  ), $atts ) );

  $id    = ( $id ) ? ' id="'. esc_attr($id) .'"' : '';
  $class = ( $class ) ? ' '. luxe_sanitize_html_classes($class) : '';

  $output  =  '<div '.$id.' class="icon icon--style-2 mb-0 mt-0'.$class.'">';
  $output .=  '<div class="icon__wrap">';
  $output .=  '<div class="icon__media">';
  $output .=  '<span class="'.esc_attr($icon).'"></span>';
  $output .=  '</div>';
  $output .=  '<h3 class="icon__title">'.esc_html($count_no).'</h3>';
  $output .=  '<div class="icon__text">'.esc_html($title).'</div>';
  $output .=  '</div>';
  $output .=  '</div><div class="empty-space marg-xs-b15"></div>';
        
  return $output;

}
add_shortcode( 'rs_counter', 'rs_counter' );
