<?php
/**
 *
 * RS Blog
 * @since 1.0.0
 * @version 1.1.0
 *
 */
function rs_blog( $atts, $content = '', $id = '' ) {
  extract( shortcode_atts( array(
    'id'               => '',
    'class'            => '',
    'cats'             => 0,
    'orderby'          => 'ID',
    'post_per_page'    => 3,
    'show_category'    => 'yes',
    'show_author'      => 'yes',
    'excerpt_length'   => '15',
    'pagination_style' => 'default',
    'exclude_posts'    => '',
  ), $atts ) );

  $id               = ( $id ) ? ' id="'. esc_attr($id) .'"' : '';
  $class            = ( $class ) ? ' '. $class : '';
  $post_blog_column = luxe_blog_post_column();

  $args = array(
    'orderby'        => $orderby,
    'posts_per_page' => $post_per_page,
  );

  if( $cats ) {
    $args['tax_query'] = array(
      array(
        'taxonomy' => 'category',
        'field'    => 'slug',
        'terms'    => explode( ',', $cats )
      )
    );
  }

  if (!empty($exclude_posts)) {
    $exclude_posts_arr = explode(',',$exclude_posts);
    if (is_array($exclude_posts_arr) && count($exclude_posts_arr) > 0) {
      $args['post__not_in'] = array_map('intval',$exclude_posts_arr);
    }
  }

  ob_start();
  $the_query = new WP_Query($args); ?>


  <div <?php echo esc_attr($id); ?> class="row blog__shortcode blog-roll__post <?php echo esc_attr($class); ?>">
    <div class="isotope isotope-content">
      <?php echo luxe_blog_post_grid_sizer(); ?>
      <?php if($the_query -> have_posts()): while ($the_query -> have_posts()) : $the_query -> the_post(); ?>
        <div <?php post_class($post_blog_column); ?>>
          <div class="recent-post mb-0">
            <?php luxe_blog_post_format(); ?>
            <div class="recent-post__wrap">
              <a href="<?php echo esc_url(get_the_permalink()); ?>" class="recent-post__title"><?php the_title(); ?></a>
              <div class="recent-post__meta">
               <?php if($show_author == 'yes') { echo get_the_author(); } ?>
               <?php if($show_category == 'yes') { echo esc_html__('on', 'luxe-addons'); ?> <?php echo get_the_category_list( esc_html__( ', ', 'luxe' ) ); } ?>
              </div>
              <div class="recent-post__excerpt"><?php echo luxe_auto_post_excerpt($excerpt_length); ?></div>
              <a class="recent-post__link" href="<?php echo esc_url(get_the_permalink()); ?>"><?php echo esc_html__('Read more', 'luxe'); ?></a>
            </div>
          </div>
          <div class="empty-space  marg-xs-b15"></div>
        </div>
      <?php endwhile; wp_reset_postdata(); else: 
        get_template_part('templates/content', 'none');
      endif; ?>
    </div>
  </div>

  <?php

  $output = ob_get_clean();
  return $output;
}
add_shortcode( 'rs_blog', 'rs_blog' );
