<?php
/**
 *
 * RS Animities
 * @since 1.0.0
 * @version 1.0.0
 *
 *
 */
function rs_animities( $atts, $content = '', $id = '' ) {

  extract( shortcode_atts( array(
    'id'      => '',
    'class'   => '',
    'heading' => 'Animities',
    'animity' => ''
  ), $atts ) );

  $id           = ( $id ) ? ' id="'. esc_attr($id) .'"' : '';
  $class        = ( $class ) ? ' '. luxe_sanitize_html_classes($class) : '';
  $animity_data = array();
  $animities    = (array) vc_param_group_parse_atts( $animity );

  foreach ($animities as $key => $value) {
    $new_data = $value;
    $new_data['icon'] = isset( $value['icon'] ) ? $value['icon'] : '';
    $new_data['label'] = isset( $value['label'] ) ? $value['label'] : '';
    $animity_data[] = $new_data;
  }
  
  $output  =  '<div '.$id.' class="block mb-0'.$class.'">';
  $output .=  (!empty($heading)) ? '<h2 class="block__title">'.esc_html($heading).'</h2>':'';
  $output .=  '<div class="block__content">';
  $output .=  '<ul class="amenities amenities--col-4">';
  foreach ($animity_data as $new_value) {
    $output .=  '<li class="amenity"><i class="fa '.esc_attr($new_value['icon']).' amenity__icon"></i>'.esc_html($new_value['label']).'</li>';
  }
  $output .=  '</ul>';
  $output .=  '</div>';
  $output .=  '</div>';
  return $output;

}
add_shortcode('rs_animities', 'rs_animities');
